/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class LodestoneAttributeEventHandler {
    public static void processAttributes(LivingDamageEvent.Pre event) {
        Entity entity;
        AttributeInstance magicResistance;
        if (event.getOriginalDamage() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        float amount = event.getOriginalDamage();
        Holder damageType = source.typeHolder();
        if (damageType.is(LodestoneDamageTypeTags.IS_MAGIC) && (magicResistance = target.getAttribute(LodestoneAttributes.MAGIC_RESISTANCE)) != null) {
            amount /= (float)Math.max(magicResistance.getValue(), (double)0.01f);
        }
        if ((entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (damageType.is(LodestoneDamageTypeTags.IS_MAGIC)) {
                AttributeInstance magicProficiency = attacker.getAttribute(LodestoneAttributes.MAGIC_PROFICIENCY);
                if (magicProficiency != null) {
                    amount *= (float)magicProficiency.getValue();
                }
                event.setNewDamage(amount);
            }
        }
    }

    public static void triggerMagicDamage(LivingDamageEvent.Post event) {
        if (event.getOriginalDamage() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Holder damageType = source.typeHolder();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            AttributeInstance magicDamage;
            LivingEntity attacker = (LivingEntity)entity;
            if (damageType.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC) && (magicDamage = attacker.getAttribute(LodestoneAttributes.MAGIC_DAMAGE)) != null && magicDamage.getValue() > 0.0 && !target.isDeadOrDying()) {
                float magicDamageAmount = (float)magicDamage.getValue();
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    if (!damageType.is(LodestoneDamageTypeTags.IGNORES_MAGIC_ATTACK_COOLDOWN_SCALAR)) {
                        magicDamageAmount *= player.getAttackStrengthScale(0.0f);
                    }
                }
                DamageSource magic = DamageTypeHelper.create((ResourceKey<DamageType>)DamageTypes.MAGIC, (Entity)attacker);
                target.invulnerableTime = 0;
                target.hurt(magic, magicDamageAmount);
            }
        }
    }
}

