/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import team.lodestar.lodestone.LodestoneLib;

public class ItemEventHandler {
    private static final HashSet<EventResponderSource> LOOKUPS = new HashSet();
    public static final EventResponderSource HELD_ITEM = ItemEventHandler.registerLookup(new EventResponderSource(LodestoneLib.lodestonePath("held_item"), e -> List.of(e.getMainHandItem())));
    public static final EventResponderSource ARMOR = ItemEventHandler.registerLookup(new EventResponderSource(LodestoneLib.lodestonePath("armor"), e -> {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : e.getArmorSlots()) {
            stacks.add(stack);
        }
        return stacks;
    }));

    public static void triggerDeathResponses(LivingDeathEvent event) {
        LivingEntity livingAttacker;
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Entity entity = source.getEntity();
        LivingEntity attacker = entity instanceof LivingEntity ? (livingAttacker = (LivingEntity)entity) : target.getLastAttacker();
        ItemEventHandler.getEventResponders(target).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.incomingDeathEvent(event, attacker, target, (ItemStack)stack)));
        if (attacker != null) {
            ItemEventHandler.getEventResponders(attacker).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.outgoingDeathEvent(event, attacker, target, (ItemStack)stack)));
        }
    }

    public static void triggerHurtResponses(LivingDamageEvent.Pre event) {
        LivingEntity livingAttacker;
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Entity entity = source.getEntity();
        LivingEntity attacker = entity instanceof LivingEntity ? (livingAttacker = (LivingEntity)entity) : target.getLastAttacker();
        ItemEventHandler.getEventResponders(target).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.incomingDamageEvent(event, attacker, target, (ItemStack)stack)));
        if (attacker != null) {
            ItemEventHandler.getEventResponders(attacker).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.outgoingDamageEvent(event, attacker, target, (ItemStack)stack)));
        }
    }

    public static void triggerHurtResponses(LivingDamageEvent.Post event) {
        LivingEntity livingAttacker;
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Entity entity = source.getEntity();
        LivingEntity attacker = entity instanceof LivingEntity ? (livingAttacker = (LivingEntity)entity) : target.getLastAttacker();
        ItemEventHandler.getEventResponders(target).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.finalizedIncomingDamageEvent(event, attacker, target, (ItemStack)stack)));
        if (attacker != null) {
            ItemEventHandler.getEventResponders(attacker).forEach(lookup -> lookup.run((eventResponderItem, stack) -> eventResponderItem.finalizedOutgoingDamageEvent(event, attacker, target, (ItemStack)stack)));
        }
    }

    public static void addAttributeTooltips(AddAttributeTooltipsEvent event) {
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (item instanceof IEventResponder) {
            IEventResponder eventResponderItem = (IEventResponder)item;
            eventResponderItem.modifyAttributeTooltipEvent(event);
        }
    }

    public static List<EventResponderLookupResult> getEventResponders(LivingEntity entity) {
        return LOOKUPS.stream().map(s -> s.getEventResponders(entity)).toList();
    }

    public static EventResponderSource registerLookup(EventResponderSource lookup) {
        LOOKUPS.add(lookup);
        return lookup;
    }

    public static interface IEventResponder {
        default public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        }

        default public void modifyAttributesEvent(ItemAttributeModifierEvent event) {
        }

        default public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }

        default public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }

        default public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }

        default public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }

        default public void incomingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }

        default public void outgoingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        }
    }

    public static class EventResponderSource {
        public final ResourceLocation id;
        public final Function<LivingEntity, Collection<ItemStack>> stackFunction;
        public final BiFunction<LivingEntity, ItemStack, IEventResponder> mapperFunction;

        public EventResponderSource(ResourceLocation id, Function<LivingEntity, Collection<ItemStack>> stackFunction) {
            this(id, stackFunction, (entity, stack) -> {
                IEventResponder eventResponderItem;
                Item patt0$temp = stack.getItem();
                return patt0$temp instanceof IEventResponder ? (eventResponderItem = (IEventResponder)patt0$temp) : null;
            });
        }

        public EventResponderSource(ResourceLocation id, Function<LivingEntity, Collection<ItemStack>> stackFunction, BiFunction<LivingEntity, ItemStack, IEventResponder> mapperFunction) {
            this.id = id;
            this.stackFunction = stackFunction;
            this.mapperFunction = mapperFunction;
        }

        public final EventResponderLookupResult getEventResponders(LivingEntity entity) {
            Collection<ItemStack> sourced = this.stackFunction.apply(entity);
            ArrayList<Pair<IEventResponder, ItemStack>> result = new ArrayList<Pair<IEventResponder, ItemStack>>();
            for (ItemStack stack : sourced) {
                IEventResponder iEventResponder = this.mapperFunction.apply(entity, stack);
                if (!(iEventResponder instanceof IEventResponder)) continue;
                IEventResponder responderItem = iEventResponder;
                result.add((Pair<IEventResponder, ItemStack>)Pair.of((Object)responderItem, (Object)stack));
            }
            return new EventResponderLookupResult(this, result);
        }
    }

    public record EventResponderLookupResult(EventResponderSource source, ArrayList<Pair<IEventResponder, ItemStack>> result) {
        public void run(BiConsumer<IEventResponder, ItemStack> consumer) {
            this.run(IEventResponder.class, consumer);
        }

        public <T extends IEventResponder> void run(Class<T> type, BiConsumer<T, ItemStack> consumer) {
            for (Pair<IEventResponder, ItemStack> pair : this.result) {
                if (!type.isInstance(pair.getFirst())) continue;
                consumer.accept((IEventResponder)type.cast(pair.getFirst()), (ItemStack)pair.getSecond());
            }
        }
    }
}

