/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.events;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.handlers.LodestoneAttributeEventHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;

@EventBusSubscriber
public class RuntimeEvents {
    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        LodestoneAttributeEventHandler.processAttributes(event);
        ItemEventHandler.triggerHurtResponses(event);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Post event) {
        ItemEventHandler.triggerHurtResponses(event);
        LodestoneAttributeEventHandler.triggerMagicDamage(event);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        ItemEventHandler.triggerDeathResponses(event);
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        WorldEventHandler.playerJoin(event);
    }

    @SubscribeEvent
    public static void worldTick(LevelTickEvent.Post event) {
        WorldEventHandler.worldTick(event);
    }
}

