/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;

public class LodestoneBlockFiller
extends ArrayList<LodestoneBlockFillerLayer> {
    public static final LodestoneLayerToken MAIN = new LodestoneLayerToken();
    protected final LodestoneBlockFillerLayer mainLayer = new LodestoneBlockFillerLayer(MAIN);

    public LodestoneBlockFiller() {
    }

    public LodestoneBlockFiller(LodestoneBlockFillerLayer ... layers) {
        this((Collection<LodestoneBlockFillerLayer>)new ArrayList<LodestoneBlockFillerLayer>(List.of(layers)));
    }

    public LodestoneBlockFiller(Collection<LodestoneBlockFillerLayer> layers) {
        this();
        this.addAll(layers);
    }

    public LodestoneBlockFiller addLayers(LodestoneLayerToken ... tokens) {
        for (LodestoneLayerToken token : tokens) {
            this.addLayers(new LodestoneBlockFillerLayer(token));
        }
        return this;
    }

    public LodestoneBlockFiller addLayers(LodestoneBlockFillerLayer ... layers) {
        this.addAll(List.of(layers));
        return this;
    }

    public LodestoneBlockFillerLayer getLayer(@NotNull LodestoneLayerToken layerToken) {
        if (layerToken.equals(MAIN)) {
            return this.mainLayer;
        }
        return this.stream().filter(l -> l.layerToken.equals(layerToken)).findFirst().orElseThrow();
    }

    public LodestoneBlockFillerLayer getMainLayer() {
        return this.mainLayer;
    }

    public LodestoneBlockFillerLayer fill(LevelAccessor level) {
        LodestoneBlockFillerLayer mainLayer = this.getMainLayer();
        mainLayer.clear();
        for (int i = 0; i < this.size(); ++i) {
            this.mergeLayers(mainLayer, (LodestoneBlockFillerLayer)this.get(i));
        }
        ArrayList discarded = mainLayer.entrySet().stream().filter(entry -> ((BlockStateEntry)entry.getValue()).tryDiscard(level, (BlockPos)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new));
        mainLayer.forEach((? super K pos, ? super V blockStateEntry) -> {
            if (!discarded.contains(blockStateEntry) && blockStateEntry.canPlace(level, (BlockPos)pos)) {
                blockStateEntry.place(level, (BlockPos)pos);
            }
        });
        return mainLayer;
    }

    protected void mergeLayers(LodestoneBlockFillerLayer toLayer, LodestoneBlockFillerLayer fromLayer) {
        fromLayer.forEach(toLayer::putIfAbsent);
    }

    public static BlockStateEntryBuilder create(BlockState state) {
        return new BlockStateEntryBuilder(state);
    }

    public static class LodestoneBlockFillerLayer
    extends HashMap<BlockPos, BlockStateEntry> {
        public final LodestoneLayerToken layerToken;

        public LodestoneBlockFillerLayer(LodestoneLayerToken layerToken) {
            this.layerToken = layerToken;
        }

        public void fill(LevelAccessor level) {
            this.forEach((pos, entry) -> {
                if (entry.canPlace(level, (BlockPos)pos)) {
                    entry.place(level, (BlockPos)pos);
                }
            });
        }

        @Override
        public void replace(BlockPos pos, Function<BlockStateEntry, BlockStateEntry> entryFunction) {
            this.replace(pos, entryFunction.apply((BlockStateEntry)this.get(pos)));
        }

        @Override
        public BlockStateEntry put(BlockPos key, BlockStateEntryBuilder value) {
            return super.put(key, value.build());
        }

        @Override
        public BlockStateEntry putIfAbsent(BlockPos key, BlockStateEntryBuilder value) {
            return super.putIfAbsent(key, value.build());
        }
    }

    public static class LodestoneLayerToken {
        public final UUID index;

        public LodestoneLayerToken(UUID index) {
            this.index = index;
        }

        public LodestoneLayerToken() {
            this(UUID.randomUUID());
        }
    }

    public static class BlockStateEntryBuilder {
        private final BlockState state;
        private EntryDiscardPredicate discardPredicate;
        private EntryPlacementPredicate placementPredicate;
        private boolean forcePlace;

        public BlockStateEntryBuilder(BlockState state) {
            this.state = state;
        }

        public BlockStateEntryBuilder setDiscardPredicate(EntryDiscardPredicate discardPredicate) {
            this.discardPredicate = discardPredicate;
            return this;
        }

        public BlockStateEntryBuilder setPlacementPredicate(EntryPlacementPredicate placementPredicate) {
            this.placementPredicate = placementPredicate;
            return this;
        }

        public BlockStateEntryBuilder setForcePlace() {
            return this.setForcePlace(true);
        }

        public BlockStateEntryBuilder setForcePlace(boolean forcePlace) {
            this.forcePlace = forcePlace;
            return this;
        }

        public BlockStateEntry build() {
            return new BlockStateEntry(this.state, this.discardPredicate, this.placementPredicate, this.forcePlace);
        }
    }

    public static class BlockStateEntry {
        private final BlockState state;
        private final EntryDiscardPredicate discardPredicate;
        private final EntryPlacementPredicate placementPredicate;
        private final boolean forcePlace;

        private BlockStateEntry(BlockState state, EntryDiscardPredicate discardPredicate, EntryPlacementPredicate placementPredicate, boolean forcePlace) {
            this.state = state;
            this.discardPredicate = discardPredicate;
            this.placementPredicate = placementPredicate;
            this.forcePlace = forcePlace;
        }

        public BlockState getState() {
            return this.state;
        }

        public boolean tryDiscard(LevelAccessor level, BlockPos pos) {
            return this.discardPredicate != null && this.discardPredicate.shouldDiscard(level, pos, this.state);
        }

        public boolean canPlace(LevelAccessor level, BlockPos pos) {
            if (level.m_151570_(pos)) {
                return false;
            }
            BlockState state = level.m_8055_(pos);
            if (this.placementPredicate != null && !this.placementPredicate.canPlace(level, pos, state)) {
                return false;
            }
            if (this.forcePlace) {
                return true;
            }
            return level.m_46859_(pos) || state.m_247087_();
        }

        public void place(LevelAccessor level, BlockPos pos) {
            level.m_7731_(pos, this.getState(), 19);
            if (level instanceof Level) {
                Level realLevel = (Level)level;
                BlockHelper.updateState(realLevel, pos);
            }
        }
    }

    public static interface EntryPlacementPredicate {
        public boolean canPlace(LevelAccessor var1, BlockPos var2, BlockState var3);
    }

    public static interface EntryDiscardPredicate {
        public boolean shouldDiscard(LevelAccessor var1, BlockPos var2, BlockState var3);
    }
}

