/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import team.lodestar.lodestone.registry.common.LodestonePlacementFillerRegistry;

public class DimensionPlacementFilter
extends PlacementFilter {
    public static final Codec<DimensionPlacementFilter> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ResourceLocation.f_135803_.listOf().fieldOf("dimensions").forGetter(o -> o.dimensions.stream().map(ResourceKey::m_135782_).collect(Collectors.toList()))).apply((Applicative)codec, r -> new DimensionPlacementFilter(r.stream().map(o -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)o)).collect(Collectors.toSet()))));
    private final Set<ResourceKey<Level>> dimensions;

    protected DimensionPlacementFilter(Set<ResourceKey<Level>> dimensions) {
        this.dimensions = dimensions;
    }

    public static DimensionPlacementFilter of(Set<ResourceKey<Level>> dimensions) {
        return new DimensionPlacementFilter(dimensions);
    }

    public PlacementModifierType<?> m_183327_() {
        return LodestonePlacementFillerRegistry.DIMENSION;
    }

    public static Set<ResourceKey<Level>> fromStrings(List<? extends String> dimensions) {
        return dimensions.stream().map(o -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
    }

    protected boolean m_213917_(PlacementContext pContext, RandomSource pRandom, BlockPos pPos) {
        ServerLevel level = pContext.m_191831_().m_6018_();
        return this.dimensions.contains(level.m_46472_());
    }
}

