/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldevent;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.network.worldevent.SyncWorldEventPacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public abstract class WorldEventInstance {
    public UUID uuid = UUID.randomUUID();
    public WorldEventType type;
    public Level level;
    public boolean discarded;
    public boolean dirty;
    public boolean frozen = false;

    public WorldEventInstance(WorldEventType type) {
        this.type = type;
    }

    public void sync(Level level) {
        if (!level.f_46443_ && this.isClientSynced()) {
            WorldEventInstance.sync(this);
        }
    }

    public boolean isClientSynced() {
        return false;
    }

    public void start(Level level) {
        this.level = level;
    }

    public void tick(Level level) {
    }

    public void end(Level level) {
        this.discarded = true;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Level getLevel() {
        return this.level;
    }

    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128362_("uuid", this.uuid);
        tag.m_128359_("type", this.type.id.toString());
        tag.m_128379_("discarded", this.discarded);
        tag.m_128379_("frozen", this.frozen);
        return tag;
    }

    public WorldEventInstance deserializeNBT(CompoundTag tag) {
        this.uuid = tag.m_128342_("uuid");
        this.type = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(new ResourceLocation(tag.m_128461_("type")));
        this.discarded = tag.m_128471_("discarded");
        this.frozen = tag.m_128471_("frozen");
        return this;
    }

    public CompoundTag synchronizeNBT() {
        return this.serializeNBT(new CompoundTag());
    }

    public static <T extends WorldEventInstance> void sync(T instance) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncWorldEventPacket(instance.type.id, true, instance.serializeNBT(new CompoundTag())));
    }

    public static <T extends WorldEventInstance> void sync(T instance, ServerPlayer player) {
        LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWorldEventPacket(instance.type.id, false, instance.serializeNBT(new CompoundTag())));
    }
}

