/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.builder;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public abstract class AbstractParticleBuilder<T extends SimpleParticleOptions> {
    double xMotion = 0.0;
    double yMotion = 0.0;
    double maxXSpeed = 0.0;
    double maxYSpeed = 0.0;
    double maxXOffset = 0.0;
    double maxYOffset = 0.0;

    public AbstractParticleBuilder<T> modifyColorData(Consumer<ColorParticleData> dataConsumer) {
        dataConsumer.accept(this.getColorData());
        return this;
    }

    public AbstractParticleBuilder<T> setColorData(ColorParticleData colorData) {
        ((SimpleParticleOptions)this.getParticleOptions()).colorData = colorData;
        return this;
    }

    public ColorParticleData getColorData() {
        return ((SimpleParticleOptions)this.getParticleOptions()).colorData;
    }

    public AbstractParticleBuilder<T> setScaleData(GenericParticleData scaleData) {
        ((SimpleParticleOptions)this.getParticleOptions()).scaleData = scaleData;
        return this;
    }

    public GenericParticleData getScaleData() {
        return ((SimpleParticleOptions)this.getParticleOptions()).scaleData;
    }

    public AbstractParticleBuilder<T> setTransparencyData(GenericParticleData transparencyData) {
        ((SimpleParticleOptions)this.getParticleOptions()).transparencyData = transparencyData;
        return this;
    }

    public GenericParticleData getTransparencyData() {
        return ((SimpleParticleOptions)this.getParticleOptions()).transparencyData;
    }

    public AbstractParticleBuilder<T> setSpinData(SpinParticleData spinData) {
        ((SimpleParticleOptions)this.getParticleOptions()).spinData = spinData;
        return this;
    }

    public SpinParticleData getSpinData() {
        return ((SimpleParticleOptions)this.getParticleOptions()).spinData;
    }

    public AbstractParticleBuilder<T> multiplyGravity(float gravityMultiplier) {
        return this.modifyGravity(f -> () -> Float.valueOf(f.floatValue() * gravityMultiplier));
    }

    public AbstractParticleBuilder<T> modifyGravity(Function<Float, Supplier<Float>> gravityReplacement) {
        ((SimpleParticleOptions)this.getParticleOptions()).gravityStrengthSupplier = gravityReplacement.apply(((SimpleParticleOptions)this.getParticleOptions()).gravityStrengthSupplier.get());
        return this;
    }

    public AbstractParticleBuilder<T> setGravityStrength(float gravity) {
        return this.setGravityStrength(() -> Float.valueOf(gravity));
    }

    public AbstractParticleBuilder<T> setGravityStrength(Supplier<Float> gravityStrengthSupplier) {
        ((SimpleParticleOptions)this.getParticleOptions()).gravityStrengthSupplier = gravityStrengthSupplier;
        return this;
    }

    public AbstractParticleBuilder<T> multiplyLifetime(float lifetimeMultiplier) {
        return this.modifyLifetime(i -> () -> (int)((float)i.intValue() * lifetimeMultiplier));
    }

    public AbstractParticleBuilder<T> modifyLifetime(Function<Integer, Supplier<Integer>> lifetimeReplacement) {
        ((SimpleParticleOptions)this.getParticleOptions()).lifetimeSupplier = lifetimeReplacement.apply(((SimpleParticleOptions)this.getParticleOptions()).lifetimeSupplier.get());
        return this;
    }

    public AbstractParticleBuilder<T> setLifetime(int lifetime) {
        return this.setLifetime(() -> lifetime);
    }

    public AbstractParticleBuilder<T> setLifetime(Supplier<Integer> lifetimeSupplier) {
        ((SimpleParticleOptions)this.getParticleOptions()).lifetimeSupplier = lifetimeSupplier;
        return this;
    }

    public AbstractParticleBuilder<T> multiplyLifeDelay(float lifeDelayMultiplier) {
        return this.modifyLifeDelay(i -> () -> (int)((float)i.intValue() * lifeDelayMultiplier));
    }

    public AbstractParticleBuilder<T> modifyLifeDelay(Function<Integer, Supplier<Integer>> lifeDelayReplacement) {
        ((SimpleParticleOptions)this.getParticleOptions()).lifeDelaySupplier = lifeDelayReplacement.apply(((SimpleParticleOptions)this.getParticleOptions()).lifeDelaySupplier.get());
        return this;
    }

    public AbstractParticleBuilder<T> setLifeDelay(int lifeDelay) {
        return this.setLifeDelay(() -> lifeDelay);
    }

    public AbstractParticleBuilder<T> setLifeDelay(Supplier<Integer> lifeDelaySupplier) {
        ((SimpleParticleOptions)this.getParticleOptions()).lifeDelaySupplier = lifeDelaySupplier;
        return this;
    }

    public AbstractParticleBuilder<T> setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        ((SimpleParticleOptions)this.getParticleOptions()).spritePicker = spritePicker;
        return this;
    }

    public AbstractParticleBuilder<T> setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType) {
        ((SimpleParticleOptions)this.getParticleOptions()).discardFunctionType = discardFunctionType;
        return this;
    }

    public abstract T getParticleOptions();
}

