/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.multiblock;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import team.lodestar.lodestone.systems.multiblock.MultiBlockComponentEntity;

public class MultiBlockStructure {
    public final ArrayList<StructurePiece> structurePieces;

    public MultiBlockStructure(ArrayList<StructurePiece> structurePieces) {
        this.structurePieces = structurePieces;
    }

    public boolean canPlace(BlockPlaceContext context) {
        return this.structurePieces.stream().allMatch(p -> p.canPlace(context));
    }

    public void place(BlockPlaceContext context) {
        this.structurePieces.forEach(s -> s.place(context.m_8083_(), context.m_43725_()));
    }

    public static MultiBlockStructure of(StructurePiece ... pieces) {
        return new MultiBlockStructure(new ArrayList<StructurePiece>(List.of(pieces)));
    }

    public static class StructurePiece {
        public final Vec3i offset;
        public final BlockState state;

        public StructurePiece(int xOffset, int yOffset, int zOffset, BlockState state) {
            this.offset = new Vec3i(xOffset, yOffset, zOffset);
            this.state = state;
        }

        public boolean canPlace(BlockPlaceContext context) {
            Level level = context.m_43725_();
            Player player = context.m_43723_();
            BlockPos pos = context.m_8083_().m_121955_(this.offset);
            BlockState existingState = context.m_43725_().m_8055_(pos);
            CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
            return existingState.m_247087_() && level.m_45752_(this.state, pos, collisioncontext);
        }

        public void place(BlockPos core, Level level) {
            this.place(core, level, this.state);
        }

        public void place(BlockPos core, Level level, BlockState state) {
            BlockPos pos = core.m_121955_(this.offset);
            level.m_7731_(pos, state, 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MultiBlockComponentEntity) {
                MultiBlockComponentEntity component = (MultiBlockComponentEntity)blockEntity;
                component.corePos = core;
            }
        }
    }
}

