/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj.lod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.model.obj.ObjModel;
import team.lodestar.lodestone.systems.model.obj.lod.LODBuilder;
import team.lodestar.lodestone.systems.model.obj.lod.LevelOfDetail;

public abstract class LODStrategy<T>
implements LODBuilder<T> {
    public List<LevelOfDetail<T>> levelsOfDetail = new ArrayList<LevelOfDetail<T>>();

    public static LODStrategy<Float> Distance(LODBuilderSetup<Float> lodBuilderSetup) {
        return new DistanceLODStrategy(lodBuilderSetup);
    }

    public static LODStrategy<Integer> Performance(LODBuilderSetup<Integer> lodBuilderSetup) {
        return new PerformanceLODStrategy(lodBuilderSetup);
    }

    public abstract LevelOfDetail<T> getLODLevel(Vector3f var1);

    public LODStrategy(LODBuilderSetup<T> lodBuilderSetup) {
        lodBuilderSetup.lodBuilder(this);
    }

    private static class DistanceLODStrategy
    extends LODStrategy<Float> {
        public DistanceLODStrategy(LODBuilderSetup<Float> lodBuilderSetup) {
            super(lodBuilderSetup);
        }

        @Override
        public LevelOfDetail<Float> getLODLevel(Vector3f modelPosition) {
            Vector3f cameraPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_252839_();
            float distanceSq = cameraPosition.distanceSquared((Vector3fc)modelPosition);
            for (LevelOfDetail levelOfDetail : this.levelsOfDetail) {
                if (!(distanceSq <= ((Float)levelOfDetail.getArgument()).floatValue())) continue;
                return levelOfDetail;
            }
            return (LevelOfDetail)this.levelsOfDetail.get(this.levelsOfDetail.size() - 1);
        }

        @Override
        public void create(Float argument, ResourceLocation modelLocation) {
            this.levelsOfDetail.add(new LevelOfDetail<Float>(new ObjModel(modelLocation), argument));
        }
    }

    public static interface LODBuilderSetup<T> {
        public void lodBuilder(LODBuilder<T> var1);
    }

    private static class PerformanceLODStrategy
    extends LODStrategy<Integer> {
        public PerformanceLODStrategy(LODBuilderSetup<Integer> lodBuilderSetup) {
            super(lodBuilderSetup);
        }

        @Override
        public LevelOfDetail<Integer> getLODLevel(Vector3f modelPosition) {
            int fps = Minecraft.m_91087_().m_260875_();
            int monitorRefreshRate = Minecraft.m_91087_().m_91268_().m_85377_();
            int optionsRefreshRate = (Integer)Minecraft.m_91087_().f_91066_.m_232035_().m_231551_();
            int steps = this.levelsOfDetail.size();
            int step = Math.min(steps - 1, (int)Math.floor((double)fps / (double)monitorRefreshRate * (double)steps));
            return (LevelOfDetail)this.levelsOfDetail.get(step);
        }

        @Override
        public void create(Integer argument, ResourceLocation modelLocation) {
            this.levelsOfDetail.add(new LevelOfDetail<Integer>(new ObjModel(modelLocation), argument));
        }
    }
}

