/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.systems.model.obj.Vertex;

public record Face(List<Vertex> vertices) {
    public void renderFace(PoseStack poseStack, RenderType renderType, int packedLight) {
        MultiBufferSource.BufferSource mcBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer buffer = mcBufferSource.m_6299_(renderType);
        int vertexCount = this.vertices.size();
        if (vertexCount == 4) {
            this.renderQuad(poseStack, buffer, packedLight);
        } else if (vertexCount == 3) {
            this.renderTriangle(poseStack, buffer, packedLight);
        } else {
            throw new RuntimeException("Face has invalid number of vertices. Supported vertex counts are 3 and 4.");
        }
    }

    public void renderTriangle(PoseStack poseStack, VertexConsumer buffer, int packedLight) {
        this.vertices().forEach(vertex -> this.addVertex(buffer, (Vertex)vertex, poseStack, packedLight));
        this.addVertex(buffer, this.vertices().get(0), poseStack, packedLight);
    }

    public void renderQuad(PoseStack poseStack, VertexConsumer buffer, int packedLight) {
        this.vertices().forEach(vertex -> this.addVertex(buffer, (Vertex)vertex, poseStack, packedLight));
    }

    private void addVertex(VertexConsumer buffer, Vertex vertex, PoseStack poseStack, int packedLight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        Vector3f position = vertex.position();
        Vector3f normal = vertex.normal();
        Vec2 uv = vertex.uv();
        buffer.m_252986_(matrix4f, position.x(), position.y(), position.z()).m_6122_(255, 255, 255, 255).m_7421_(uv.f_82470_, -uv.f_82471_).m_86008_(OverlayTexture.f_118083_).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_85969_(packedLight).m_5752_();
    }

    public Vector3f getCentroid() {
        Vector3f centroid = new Vector3f();
        for (Vertex vertex : this.vertices) {
            centroid.add((Vector3fc)vertex.position());
        }
        centroid.div((float)this.vertices.size());
        return centroid;
    }
}

