/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="lodestone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LodestoneShaderRegistry {
    public static ShaderHolder LODESTONE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("lodestone_texture"), DefaultVertexFormat.f_85820_, "LumiTransparency");
    public static ShaderHolder LODESTONE_TEXT = new ShaderHolder(LodestoneLib.lodestonePath("lodestone_text"), DefaultVertexFormat.f_85820_, new String[0]);
    public static ShaderHolder PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("particle/lodestone_particle"), DefaultVertexFormat.f_85813_, "LumiTransparency", "DepthFade");
    public static ShaderHolder SCREEN_PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("screen/screen_particle"), DefaultVertexFormat.f_85819_, new String[0]);
    public static ShaderHolder DISTORTED_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("screen/distorted_texture"), DefaultVertexFormat.f_85818_, "Speed", "TimeOffset", "Intensity", "XFrequency", "YFrequency", "UVCoordinates");
    public static ShaderHolder SCROLLING_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_texture"), DefaultVertexFormat.f_85820_, "Speed", "LumiTransparency");
    public static ShaderHolder TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/triangle_texture"), DefaultVertexFormat.f_85820_, "LumiTransparency");
    public static ShaderHolder SCROLLING_TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_triangle_texture"), DefaultVertexFormat.f_85820_, "Speed", "LumiTransparency");

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) {
        LodestoneShaderRegistry.registerShader(event, LODESTONE_TEXTURE);
        LodestoneShaderRegistry.registerShader(event, LODESTONE_TEXT);
        LodestoneShaderRegistry.registerShader(event, PARTICLE);
        LodestoneShaderRegistry.registerShader(event, SCREEN_PARTICLE);
        LodestoneShaderRegistry.registerShader(event, DISTORTED_TEXTURE);
        LodestoneShaderRegistry.registerShader(event, SCROLLING_TEXTURE);
        LodestoneShaderRegistry.registerShader(event, TRIANGLE_TEXTURE);
        LodestoneShaderRegistry.registerShader(event, SCROLLING_TRIANGLE_TEXTURE);
    }

    public static void registerShader(RegisterShadersEvent event, ShaderHolder shaderHolder) {
        try {
            ResourceProvider provider = event.getResourceProvider();
            event.registerShader((ShaderInstance)shaderHolder.createInstance(provider), shaderHolder::setShaderInstance);
        }
        catch (IOException e) {
            LodestoneLib.LOGGER.error("Error registering shader", (Throwable)e);
            e.printStackTrace();
        }
    }
}

