/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeData;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

public class LodestoneRenderTypeRegistry
extends RenderStateShard {
    public static final Runnable TRANSPARENT_FUNCTION = () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    public static final Runnable ADDITIVE_FUNCTION = () -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    public static final RenderStateShard.EmptyTextureStateShard NO_TEXTURE = RenderStateShard.f_110147_;
    public static final RenderStateShard.LightmapStateShard LIGHTMAP = RenderStateShard.f_110152_;
    public static final RenderStateShard.LightmapStateShard NO_LIGHTMAP = RenderStateShard.f_110153_;
    public static final RenderStateShard.CullStateShard CULL = RenderStateShard.f_110158_;
    public static final RenderStateShard.CullStateShard NO_CULL = RenderStateShard.f_110110_;
    public static final HashMap<Pair<Object, LodestoneRenderType>, LodestoneRenderType> COPIES = new HashMap();
    public static final Function<RenderTypeData, LodestoneRenderType> GENERIC = data -> LodestoneRenderTypeRegistry.createGenericRenderType(data.name, data.format, data.mode, data.shader, data.transparency, data.texture, data.cull);
    private static Consumer<LodestoneCompositeStateBuilder> MODIFIER;
    public static final LodestoneRenderType ADDITIVE_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK_PARTICLE;
    public static final LodestoneRenderType ADDITIVE_BLOCK;
    public static final LodestoneRenderType ADDITIVE_SOLID;
    public static final LodestoneRenderType TRANSPARENT_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType TRANSPARENT_BLOCK;
    public static final LodestoneRenderType TRANSPARENT_SOLID;
    public static final LodestoneRenderType LUMITRANSPARENT_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK_PARTICLE;
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK;
    public static final LodestoneRenderType LUMITRANSPARENT_SOLID;
    public static final RenderTypeProvider TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE;
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider TRANSPARENT_TEXT;
    public static final RenderTypeProvider ADDITIVE_TEXTURE;
    public static final RenderTypeProvider ADDITIVE_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_SCROLLING_TEXTURE_TRIANGLE;
    public static final RenderTypeProvider ADDITIVE_TEXT;

    public LodestoneRenderTypeRegistry(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    @Deprecated
    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(name, format, VertexFormat.Mode.QUADS, shader, transparency, (RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false), CULL);
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.EmptyTextureStateShard texture, RenderStateShard.CullStateShard cull) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(name, format, mode, LodestoneRenderTypeRegistry.builder().setShaderState(shader).setTransparencyState(transparency).setTextureState(texture).setLightmapState(LIGHTMAP).setCullState(cull));
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(name, format, mode, builder, null);
    }

    public static LodestoneRenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder, ShaderUniformHandler handler) {
        if (MODIFIER != null) {
            MODIFIER.accept(builder);
        }
        LodestoneRenderType type = LodestoneRenderType.createRenderType(name, format, builder.mode != null ? builder.mode : mode, 256, false, true, builder.m_110691_(true));
        RenderHandler.addRenderType(type);
        if (handler != null) {
            LodestoneRenderTypeRegistry.applyUniformChanges(type, handler);
        }
        MODIFIER = null;
        return type;
    }

    public static LodestoneRenderType copyWithUniformChanges(LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(LodestoneRenderTypeRegistry.copy(type), handler);
    }

    public static LodestoneRenderType copyWithUniformChanges(String newName, LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(LodestoneRenderTypeRegistry.copy(newName, type), handler);
    }

    public static LodestoneRenderType applyUniformChanges(LodestoneRenderType type, ShaderUniformHandler handler) {
        RenderHandler.UNIFORM_HANDLERS.put(type, handler);
        return type;
    }

    public static LodestoneRenderType copy(LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(type));
    }

    public static LodestoneRenderType copy(String newName, LodestoneRenderType type) {
        return GENERIC.apply(new RenderTypeData(newName, type));
    }

    public static LodestoneRenderType copyAndStore(Object index, LodestoneRenderType type) {
        return COPIES.computeIfAbsent((Pair<Object, LodestoneRenderType>)Pair.of((Object)index, (Object)((Object)type)), p -> GENERIC.apply(new RenderTypeData(type)));
    }

    public static LodestoneRenderType copyAndStore(Object index, LodestoneRenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(LodestoneRenderTypeRegistry.copyAndStore(index, type), handler);
    }

    public static void addRenderTypeModifier(Consumer<LodestoneCompositeStateBuilder> modifier) {
        MODIFIER = modifier;
    }

    public static LodestoneCompositeStateBuilder builder() {
        return new LodestoneCompositeStateBuilder().setLightmapState(LIGHTMAP);
    }

    static {
        ADDITIVE_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("additive_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.PARTICLE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setTextureState(TextureAtlas.f_118260_).setCullState(NO_CULL));
        ADDITIVE_BLOCK_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("additive_block_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.PARTICLE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setTextureState(TextureAtlas.f_118259_).setCullState(NO_CULL));
        ADDITIVE_BLOCK = LodestoneRenderTypeRegistry.createGenericRenderType("additive_block", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXTURE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setTextureState(TextureAtlas.f_118259_));
        ADDITIVE_SOLID = LodestoneRenderTypeRegistry.createGenericRenderType("additive_block", DefaultVertexFormat.f_85816_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(f_173099_).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setTextureState(NO_TEXTURE));
        TRANSPARENT_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("transparent_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.PARTICLE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setTextureState(TextureAtlas.f_118260_).setCullState(NO_CULL));
        TRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("transparent_block_particle", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.PARTICLE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setTextureState(TextureAtlas.f_118259_).setCullState(NO_CULL));
        TRANSPARENT_BLOCK = LodestoneRenderTypeRegistry.createGenericRenderType("transparent_block", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXTURE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setTextureState(TextureAtlas.f_118259_));
        TRANSPARENT_SOLID = LodestoneRenderTypeRegistry.createGenericRenderType("transparent_block", DefaultVertexFormat.f_85816_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(f_173099_).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setTextureState(NO_TEXTURE));
        LUMITRANSPARENT_PARTICLE = LodestoneRenderTypeRegistry.copyWithUniformChanges("lodestone:lumitransparent_particle", TRANSPARENT_PARTICLE, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypeRegistry.copyWithUniformChanges("lodestone:lumitransparent_block_particle", TRANSPARENT_BLOCK_PARTICLE, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_BLOCK = LodestoneRenderTypeRegistry.copyWithUniformChanges("lodestone:lumitransparent_block", TRANSPARENT_BLOCK, ShaderUniformHandler.LUMITRANSPARENT);
        LUMITRANSPARENT_SOLID = LodestoneRenderTypeRegistry.copyWithUniformChanges("lodestone:lumitransparent_solid", TRANSPARENT_SOLID, ShaderUniformHandler.LUMITRANSPARENT);
        TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXTURE).setTransparencyState(StateShards.f_110134_).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        TRANSPARENT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("transparent_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXTURE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        TRANSPARENT_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("transparent_texture_triangles", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.TRIANGLE_TEXTURE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("transparent_scrolling_texture_triangles", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.SCROLLING_TRIANGLE_TEXTURE).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        TRANSPARENT_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("transparent_text", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXT.getShard()).setTransparencyState(StateShards.f_110139_).setTextureState(token.get())));
        ADDITIVE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("additive_texture", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXTURE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        ADDITIVE_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("additive_texture_triangle", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.TRIANGLE_TEXTURE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        ADDITIVE_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("additive_scrolling_texture_triangle", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.SCROLLING_TRIANGLE_TEXTURE).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setLightmapState(LIGHTMAP).setCullState(CULL).setTextureState(token.get())));
        ADDITIVE_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypeRegistry.createGenericRenderType("additive_text", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, LodestoneRenderTypeRegistry.builder().setShaderState(LodestoneShaderRegistry.LODESTONE_TEXT.getShard()).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY).setTextureState(token.get())));
    }

    public static class LodestoneCompositeStateBuilder
    extends RenderType.CompositeState.CompositeStateBuilder {
        protected VertexFormat.Mode mode;

        LodestoneCompositeStateBuilder() {
        }

        public LodestoneCompositeStateBuilder replaceVertexFormat(VertexFormat.Mode mode) {
            this.mode = mode;
            return this;
        }

        public LodestoneCompositeStateBuilder setTextureState(ResourceLocation texture) {
            return this.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
        }

        public LodestoneCompositeStateBuilder setShaderState(ShaderHolder shaderHolder) {
            return this.setShaderState(shaderHolder.getShard());
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
            return (LodestoneCompositeStateBuilder)super.m_173290_(pTextureState);
        }

        public LodestoneCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
            return (LodestoneCompositeStateBuilder)super.m_173292_(pShaderState);
        }

        public LodestoneCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
            return (LodestoneCompositeStateBuilder)super.m_110685_(pTransparencyState);
        }

        public LodestoneCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
            return (LodestoneCompositeStateBuilder)super.m_110663_(pDepthTestState);
        }

        public LodestoneCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
            return (LodestoneCompositeStateBuilder)super.m_110661_(pCullState);
        }

        public LodestoneCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
            return (LodestoneCompositeStateBuilder)super.m_110671_(pLightmapState);
        }

        public LodestoneCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
            return (LodestoneCompositeStateBuilder)super.m_110677_(pOverlayState);
        }

        public LodestoneCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
            return (LodestoneCompositeStateBuilder)super.m_110669_(pLayerState);
        }

        public LodestoneCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
            return (LodestoneCompositeStateBuilder)super.m_110675_(pOutputState);
        }

        public LodestoneCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
            return (LodestoneCompositeStateBuilder)super.m_110683_(pTexturingState);
        }

        public LodestoneCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
            return (LodestoneCompositeStateBuilder)super.m_110687_(pWriteMaskState);
        }

        public LodestoneCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
            return (LodestoneCompositeStateBuilder)super.m_110673_(pLineState);
        }
    }
}

