/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class RenderHelper {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static ShaderInstance getShader(RenderType type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType renderType = (LodestoneRenderType)type;
            Optional shader = renderType.state.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyShard(RenderType type) {
        if (type instanceof LodestoneRenderType) {
            LodestoneRenderType compositeRenderType = (LodestoneRenderType)type;
            return compositeRenderType.state.f_110577_;
        }
        return null;
    }

    public static void vertexPos(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z) {
        vertexConsumer.m_252986_(last, x, y, z).m_5752_();
    }

    public static void vertexPosUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v) {
        vertexConsumer.m_252986_(last, x, y, z).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v, int light) {
        vertexConsumer.m_252986_(last, x, y, z).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static void vertexPosColor(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_5752_();
    }

    public static void vertexPosColorUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosColorUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }

    public static Vec2 screenSpaceQuadOffsets(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / DataHelper.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static Vector4f midpoint(Vector4f a, Vector4f b) {
        return new Vector4f((a.x() + b.x()) * 0.5f, (a.y() + b.y()) * 0.5f, (a.z() + b.z()) * 0.5f, (a.w() + b.w()) * 0.5f);
    }

    public static Vec2 worldPosToTexCoord(Vector3f worldPos, PoseStack viewModelStack) {
        Matrix4f viewMat = viewModelStack.m_85850_().m_252922_();
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        Vector3f localPos = new Vector3f((Vector3fc)worldPos);
        localPos.sub((Vector3fc)Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_252839_());
        Vector4f pos = new Vector4f((Vector3fc)localPos, 0.0f);
        pos.mul((Matrix4fc)viewMat);
        pos.mul((Matrix4fc)projMat);
        VecHelper.Vector4fHelper.perspectiveDivide(pos);
        return new Vec2((pos.x() + 1.0f) / 2.0f, (pos.y() + 1.0f) / 2.0f);
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, List<Vec3> points, float lineWidth, int r, int g, int b, int a) {
        Vec3 origin = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Vec3 target = points.get(i);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 start, Vec3 end, int steps, float lineWidth, int r, int g, int b, int a, Consumer<Vec3> pointConsumer) {
        Vec3 origin = start;
        for (int i = 1; i <= steps; ++i) {
            Vec3 target = start.m_82549_(end.m_82546_(start).m_82490_((double)((float)i / (float)steps)));
            pointConsumer.accept(target);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 local, Vec3 target, float lineWidth, int r, int g, int b, int a) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110475_());
        float rotY = (float)Mth.m_14136_((double)(target.f_82479_ - local.f_82479_), (double)(target.f_82481_ - local.f_82481_));
        double distX = target.f_82479_ - local.f_82479_;
        double distZ = target.f_82481_ - local.f_82481_;
        float rotX = (float)Mth.m_14136_((double)(target.f_82480_ - local.f_82480_), (double)Mth.m_14116_((float)((float)(distX * distX + distZ * distZ))));
        ps.m_85836_();
        ps.m_85837_(local.f_82479_, local.f_82480_, local.f_82481_);
        ps.m_252781_(VecHelper.Vector3fHelper.rotation(rotY, VecHelper.Vector3fHelper.YP));
        ps.m_252781_(VecHelper.Vector3fHelper.rotation(rotX, VecHelper.Vector3fHelper.XN));
        float distance = (float)local.m_82554_(target);
        Matrix4f matrix = ps.m_85850_().m_252922_();
        float halfWidth = lineWidth / 2.0f;
        builder.m_252986_(matrix, -halfWidth, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, halfWidth, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, halfWidth, 0.0f, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, -halfWidth, 0.0f, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, -halfWidth, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, halfWidth, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, halfWidth, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, -halfWidth, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        ps.m_85849_();
    }
}

