/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import team.lodestar.lodestone.compability.CuriosCompat;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.systems.item.IEventResponderItem;

public class ItemHelper {
    public static ArrayList<ItemStack> copyWithNewCount(List<ItemStack> stacks, int newCount) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(newCount);
            newStacks.add(copy);
        }
        return newStacks;
    }

    public static ItemStack copyWithNewCount(ItemStack stack, int newCount) {
        ItemStack newStack = stack.m_41777_();
        newStack.m_41764_(newCount);
        return newStack;
    }

    public static <T extends LivingEntity> boolean damageItem(ItemStack stack, int amount, T entityIn, Consumer<T> onBroken) {
        if (!(entityIn.m_9236_().f_46443_ || entityIn instanceof Player && ((Player)entityIn).m_150110_().f_35937_ || !stack.m_41763_() || !stack.m_220157_(amount = stack.m_41720_().damageItem(stack, amount, entityIn, onBroken), entityIn.m_217043_(), entityIn instanceof ServerPlayer ? (ServerPlayer)entityIn : null))) {
            onBroken.accept(entityIn);
            Item item = stack.m_41720_();
            stack.m_41774_(1);
            if (entityIn instanceof Player) {
                ((Player)entityIn).m_36246_(Stats.f_12983_.m_12902_((Object)item));
            }
            stack.m_41721_(0);
            return true;
        }
        return false;
    }

    public static <T extends Entity> Entity getClosestEntity(List<T> entities, Vec3 pos) {
        double cachedDistance = -1.0;
        Entity resultEntity = null;
        for (Entity entity : entities) {
            double newDistance = entity.m_20275_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (cachedDistance != -1.0 && !(newDistance < cachedDistance)) continue;
            cachedDistance = newDistance;
            resultEntity = entity;
        }
        return resultEntity;
    }

    public static ArrayList<ItemStack> nonEmptyStackList(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            nonEmptyStacks.add(stack);
        }
        return nonEmptyStacks;
    }

    public static ArrayList<ItemStack> getEventResponders(LivingEntity attacker) {
        ArrayList<ItemStack> itemStacks = CuriosCompat.LOADED ? CurioHelper.getEquippedCurios(attacker, p -> p.m_41720_() instanceof IEventResponderItem) : new ArrayList<ItemStack>();
        ItemStack stack = attacker.m_21205_();
        if (stack.m_41720_() instanceof IEventResponderItem) {
            itemStacks.add(stack);
        }
        attacker.m_6168_().forEach(s -> {
            if (s.m_41720_() instanceof IEventResponderItem) {
                itemStacks.add((ItemStack)s);
            }
        });
        return itemStacks;
    }

    public static void applyEnchantments(LivingEntity user, Entity target, ItemStack stack) {
        EnchantmentHelper.EnchantmentVisitor visitor = (enchantment, level) -> enchantment.m_7677_(user, target, level);
        if (user != null) {
            EnchantmentHelper.m_44853_((EnchantmentHelper.EnchantmentVisitor)visitor, (Iterable)user.m_20158_());
        }
        if (user instanceof Player) {
            EnchantmentHelper.m_44850_((EnchantmentHelper.EnchantmentVisitor)visitor, (ItemStack)stack);
        }
    }

    public static void giveItemToEntity(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        } else {
            ItemHelper.spawnItemOnEntity(entity, stack);
        }
    }

    public static void quietlyGiveItemToPlayer(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.m_150109_());
        Level level = player.m_9236_();
        ItemStack remainder = stack;
        if (!remainder.m_41619_()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
        }
        if (!remainder.m_41619_() && !level.f_46443_) {
            ItemHelper.spawnItemOnEntity((LivingEntity)player, stack);
        }
    }

    public static void spawnItemOnEntity(LivingEntity entity, ItemStack stack) {
        Level level = entity.m_9236_();
        ItemEntity itemEntity = new ItemEntity(level, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), stack);
        itemEntity.m_32010_(40);
        itemEntity.m_20256_(itemEntity.m_20184_().m_82542_(0.0, 1.0, 0.0));
        level.m_7967_((Entity)itemEntity);
    }
}

