/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackRetrievalKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ScreenParticleHandler {
    public static final Map<ScreenParticleItemStackKey, ScreenParticleHolder> ITEM_PARTICLES = new HashMap<ScreenParticleItemStackKey, ScreenParticleHolder>();
    public static final Map<ScreenParticleItemStackRetrievalKey, ItemStack> ITEM_STACK_CACHE = new HashMap<ScreenParticleItemStackRetrievalKey, ItemStack>();
    public static final Collection<ScreenParticleItemStackRetrievalKey> ACTIVELY_ACCESSED_KEYS = new ArrayList<ScreenParticleItemStackRetrievalKey>();
    public static ScreenParticleHolder cachedItemParticles = null;
    public static int currentItemX;
    public static int currentItemY;
    public static final Tesselator TESSELATOR;
    public static boolean canSpawnParticles;
    public static boolean renderingHotbar;

    public static void tickParticles() {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        ITEM_PARTICLES.values().forEach(ScreenParticleHolder::tick);
        ITEM_PARTICLES.values().removeIf(ScreenParticleHolder::isEmpty);
        ITEM_STACK_CACHE.keySet().removeIf(k -> !ACTIVELY_ACCESSED_KEYS.contains(k));
        ACTIVELY_ACCESSED_KEYS.clear();
        canSpawnParticles = true;
    }

    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            canSpawnParticles = false;
        }
    }

    public static void renderItemStackEarly(PoseStack poseStack, ItemStack stack, int x, int y) {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91074_ != null) {
            List<ParticleEmitterHandler.ItemParticleSupplier> emitters;
            if (minecraft.m_91104_()) {
                return;
            }
            if (!stack.m_41619_() && (emitters = ParticleEmitterHandler.EMITTERS.get(stack.m_41720_())) != null) {
                Screen pose;
                currentItemX = x + 8;
                currentItemY = y + 8;
                if (currentItemX == 8 && currentItemY == 8) {
                    pose = poseStack.m_85850_().m_252922_();
                    float xOffset = pose.m30();
                    float yOffset = pose.m31();
                    currentItemX = (int)((float)currentItemX + xOffset);
                    currentItemY = (int)((float)currentItemY + yOffset);
                } else if (!renderingHotbar && (pose = minecraft.f_91080_) instanceof AbstractContainerScreen) {
                    AbstractContainerScreen containerScreen = (AbstractContainerScreen)pose;
                    currentItemX += containerScreen.f_97735_;
                    currentItemY += containerScreen.f_97736_;
                }
                for (ParticleEmitterHandler.ItemParticleSupplier emitter : emitters) {
                    ScreenParticleHandler.renderParticles(ScreenParticleHandler.spawnAndPullParticles(minecraft.f_91073_, emitter, stack, false));
                    cachedItemParticles = ScreenParticleHandler.spawnAndPullParticles(minecraft.f_91073_, emitter, stack, true);
                }
            }
        }
    }

    public static ScreenParticleHolder spawnAndPullParticles(ClientLevel level, ParticleEmitterHandler.ItemParticleSupplier emitter, ItemStack stack, boolean isRenderedAfterItem) {
        ScreenParticleItemStackRetrievalKey cacheKey = new ScreenParticleItemStackRetrievalKey(renderingHotbar, isRenderedAfterItem, currentItemX, currentItemY);
        ScreenParticleHolder target = ITEM_PARTICLES.computeIfAbsent(new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, stack), s -> new ScreenParticleHolder());
        ScreenParticleHandler.pullFromParticleVault(cacheKey, stack, target, isRenderedAfterItem);
        if (canSpawnParticles) {
            if (isRenderedAfterItem) {
                emitter.spawnLateParticles(target, (Level)level, Minecraft.m_91087_().f_90991_.f_92518_, stack, currentItemX, currentItemY);
            } else {
                emitter.spawnEarlyParticles(target, (Level)level, Minecraft.m_91087_().f_90991_.f_92518_, stack, currentItemX, currentItemY);
            }
        }
        ACTIVELY_ACCESSED_KEYS.add(cacheKey);
        return target;
    }

    public static void pullFromParticleVault(ScreenParticleItemStackRetrievalKey cacheKey, ItemStack currentStack, ScreenParticleHolder target, boolean isRenderedAfterItem) {
        ItemStack oldStack;
        if (ITEM_STACK_CACHE.containsKey(cacheKey) && (oldStack = ITEM_STACK_CACHE.get(cacheKey)) != currentStack && oldStack.m_41720_().equals(currentStack.m_41720_())) {
            ScreenParticleItemStackKey oldKey = new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, oldStack);
            ScreenParticleHolder oldParticles = ITEM_PARTICLES.get(oldKey);
            if (oldParticles != null) {
                target.addFrom(oldParticles);
            }
            ITEM_STACK_CACHE.remove(cacheKey);
            ITEM_PARTICLES.remove(oldKey);
        }
        ITEM_STACK_CACHE.put(cacheKey, currentStack);
    }

    public static void renderItemStackLate() {
        if (cachedItemParticles != null) {
            ScreenParticleHandler.renderParticles(cachedItemParticles);
            cachedItemParticles = null;
        }
    }

    public static void renderParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.particles.forEach((renderType, particles) -> {
            renderType.begin(TESSELATOR.m_85915_(), Minecraft.m_91087_().f_90987_);
            for (ScreenParticle next : particles) {
                next.render(TESSELATOR.m_85915_());
            }
            renderType.end(TESSELATOR);
        });
    }

    public static void clearParticles() {
        ITEM_PARTICLES.values().forEach(ScreenParticleHandler::clearParticles);
    }

    public static void clearParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.particles.values().forEach(ArrayList::clear);
    }

    public static <T extends ScreenParticleOptions> ScreenParticle addParticle(ScreenParticleHolder screenParticleTarget, T options, double x, double y, double xMotion, double yMotion) {
        Minecraft minecraft = Minecraft.m_91087_();
        ScreenParticleType<?> type = options.type;
        ScreenParticle particle = type.provider.createParticle(minecraft.f_91073_, options, x, y, xMotion, yMotion);
        ArrayList list = screenParticleTarget.particles.computeIfAbsent(options.renderType, a -> new ArrayList());
        list.add(particle);
        return particle;
    }

    static {
        TESSELATOR = new Tesselator();
    }
}

