/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.capability.LodestonePlayerDataCapability;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.events.types.worldevent.WorldEventCreationEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventDiscardEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventRenderEvent;
import team.lodestar.lodestone.events.types.worldevent.WorldEventTickEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPacket;
import team.lodestar.lodestone.registry.client.LodestoneWorldEventRendererRegistry;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventRenderer;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class WorldEventHandler {
    public static <T extends WorldEventInstance> T addWorldEvent(Level level, T instance) {
        return WorldEventHandler.addWorldEvent(level, true, instance);
    }

    public static <T extends WorldEventInstance> T addWorldEvent(Level level, boolean shouldStart, T instance) {
        MinecraftForge.EVENT_BUS.post((Event)new WorldEventCreationEvent(instance, level));
        LodestoneWorldDataCapability.getCapabilityOptional(level).ifPresent(capability -> {
            capability.inboundWorldEvents.add(instance);
            if (shouldStart) {
                instance.start(level);
            }
            instance.sync(level);
        });
        return instance;
    }

    public static void playerJoin(EntityJoinLevelEvent event) {
        Player player;
        Level level;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (level = (player = (Player)entity).m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LodestonePlayerDataCapability.getCapabilityOptional(player).ifPresent(capability -> LodestoneWorldDataCapability.getCapabilityOptional((Level)level2).ifPresent(worldCapability -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    for (WorldEventInstance instance : worldCapability.activeWorldEvents) {
                        if (!instance.isClientSynced()) continue;
                        WorldEventInstance.sync(instance, serverPlayer);
                    }
                }
            }));
        }
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && !event.level.f_46443_) {
            WorldEventHandler.tick(event.level);
        }
    }

    public static void tick(Level level) {
        LodestoneWorldDataCapability.getCapabilityOptional(level).ifPresent(c -> {
            c.activeWorldEvents.addAll(c.inboundWorldEvents);
            c.inboundWorldEvents.clear();
            Iterator<WorldEventInstance> iterator = c.activeWorldEvents.iterator();
            while (iterator.hasNext()) {
                WorldEventInstance instance = iterator.next();
                if (instance.discarded) {
                    MinecraftForge.EVENT_BUS.post((Event)new WorldEventDiscardEvent(instance, level));
                    iterator.remove();
                    continue;
                }
                if (!instance.isFrozen()) {
                    MinecraftForge.EVENT_BUS.post((Event)new WorldEventTickEvent(instance, level));
                    instance.tick(level);
                }
                if (!instance.dirty) continue;
                LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateWorldEventPacket(instance.uuid, instance.synchronizeNBT()));
                instance.dirty = false;
            }
        });
    }

    public static void serializeNBT(LodestoneWorldDataCapability capability, CompoundTag tag) {
        CompoundTag worldTag = new CompoundTag();
        worldTag.m_128405_("worldEventCount", capability.activeWorldEvents.size());
        for (int i = 0; i < capability.activeWorldEvents.size(); ++i) {
            WorldEventInstance instance = capability.activeWorldEvents.get(i);
            CompoundTag instanceTag = new CompoundTag();
            instance.serializeNBT(instanceTag);
            worldTag.m_128365_("worldEvent_" + i, (Tag)instanceTag);
        }
        tag.m_128365_("worldEventData", (Tag)worldTag);
    }

    public static void deserializeNBT(LodestoneWorldDataCapability capability, CompoundTag tag) {
        capability.activeWorldEvents.clear();
        CompoundTag worldTag = tag.m_128469_("worldEventData");
        int worldEventCount = worldTag.m_128451_("worldEventCount");
        for (int i = 0; i < worldEventCount; ++i) {
            CompoundTag instanceTag = worldTag.m_128469_("worldEvent_" + i);
            WorldEventType reader = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(new ResourceLocation(instanceTag.m_128461_("type")));
            WorldEventInstance eventInstance = reader.createInstance(instanceTag);
            capability.activeWorldEvents.add(eventInstance);
        }
    }

    public static class ClientOnly {
        public static void renderWorldEvents(PoseStack stack, float partialTicks) {
            LodestoneWorldDataCapability.getCapabilityOptional((Level)Minecraft.m_91087_().f_91073_).ifPresent(capability -> {
                for (WorldEventInstance instance : capability.activeWorldEvents) {
                    WorldEventRenderer<WorldEventInstance> renderer = LodestoneWorldEventRendererRegistry.RENDERERS.get(instance.type);
                    if (renderer == null || !renderer.canRender(instance)) continue;
                    MinecraftForge.EVENT_BUS.post((Event)new WorldEventRenderEvent(instance, renderer, stack, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks));
                    renderer.render(instance, stack, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget(), partialTicks);
                }
            });
        }
    }
}

