/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class RenderHandler {
    public static final HashMap<RenderType, BufferBuilder> BUFFERS = new HashMap();
    public static final HashMap<RenderType, BufferBuilder> PARTICLE_BUFFERS = new HashMap();
    public static final HashMap<RenderType, BufferBuilder> LATE_BUFFERS = new HashMap();
    public static final HashMap<RenderType, BufferBuilder> LATE_PARTICLE_BUFFERS = new HashMap();
    public static final HashMap<RenderType, ShaderUniformHandler> UNIFORM_HANDLERS = new HashMap();
    public static final Collection<RenderType> TRANSPARENT_RENDER_TYPES = new ArrayList<RenderType>();
    public static RenderTarget LODESTONE_DEPTH_CACHE = new TextureTarget(Minecraft.m_91087_().m_91385_().f_83915_, Minecraft.m_91087_().m_91385_().f_83916_, true, Minecraft.f_91002_);
    public static LodestoneRenderLayer DELAYED_RENDER;
    public static LodestoneRenderLayer LATE_DELAYED_RENDER;
    public static PoseStack MAIN_POSE_STACK;
    public static Matrix4f MATRIX4F;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static FogShape FOG_SHAPE;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;

    public static void onClientSetup(FMLClientSetupEvent event) {
        DELAYED_RENDER = new LodestoneRenderLayer(BUFFERS, PARTICLE_BUFFERS);
        LATE_DELAYED_RENDER = new LodestoneRenderLayer(LATE_BUFFERS, LATE_PARTICLE_BUFFERS);
    }

    public static void resize(int width, int height) {
        if (LODESTONE_DEPTH_CACHE != null) {
            LODESTONE_DEPTH_CACHE.m_83941_(width, height, Minecraft.f_91002_);
        }
    }

    public static void endBatches() {
        RenderHandler.copyDepthBuffer(LODESTONE_DEPTH_CACHE);
        RenderHandler.endBatches(DELAYED_RENDER);
        RenderHandler.endBatches(LATE_DELAYED_RENDER);
    }

    public static void endBatches(LodestoneRenderLayer renderLayer) {
        Matrix4f last = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedParticles(renderLayer, true);
        if (MATRIX4F != null) {
            RenderSystem.getModelViewMatrix().set((Matrix4fc)MATRIX4F);
        }
        RenderHandler.renderBufferedBatches(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, false);
        RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
        RenderHandler.renderBufferedParticles(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    public static void cacheFogData(ViewportEvent.RenderFog event) {
        FOG_NEAR = event.getNearPlaneDistance();
        FOG_FAR = event.getFarPlaneDistance();
        FOG_SHAPE = event.getFogShape();
    }

    public static void cacheFogData(ViewportEvent.ComputeFogColor event) {
        FOG_RED = event.getRed();
        FOG_GREEN = event.getGreen();
        FOG_BLUE = event.getBlue();
    }

    public static void beginBufferedRendering() {
        float[] shaderFogColor = RenderSystem.getShaderFogColor();
        float fogRed = shaderFogColor[0];
        float fogGreen = shaderFogColor[1];
        float fogBlue = shaderFogColor[2];
        float shaderFogStart = RenderSystem.getShaderFogStart();
        float shaderFogEnd = RenderSystem.getShaderFogEnd();
        FogShape shaderFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void endBufferedRendering() {
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
    }

    public static void renderBufferedParticles(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.getParticleTarget(), renderLayer.getParticleBuffers(), transparentOnly);
    }

    public static void renderBufferedBatches(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.getTarget(), renderLayer.getBuffers(), transparentOnly);
    }

    private static void renderBufferedBatches(MultiBufferSource.BufferSource bufferSource, HashMap<RenderType, BufferBuilder> buffer, boolean transparentOnly) {
        if (transparentOnly) {
            RenderHandler.endBatches(bufferSource, TRANSPARENT_RENDER_TYPES);
        } else {
            ArrayList<RenderType> nonTransparentRenderTypes = new ArrayList<RenderType>(buffer.keySet());
            nonTransparentRenderTypes.removeIf(TRANSPARENT_RENDER_TYPES::contains);
            RenderHandler.endBatches(bufferSource, nonTransparentRenderTypes);
        }
    }

    public static void endBatches(MultiBufferSource.BufferSource source, Collection<RenderType> renderTypes) {
        for (RenderType type : renderTypes) {
            ShaderInstance instance = RenderHelper.getShader(type);
            if (UNIFORM_HANDLERS.containsKey(type)) {
                ShaderUniformHandler handler = UNIFORM_HANDLERS.get(type);
                handler.updateShaderData(instance);
            }
            instance.m_173350_("SceneDepthBuffer", (Object)LODESTONE_DEPTH_CACHE.m_83980_());
            instance.m_173356_("InvProjMat").m_5679_(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
            source.m_109912_(type);
            if (!(instance instanceof ExtendedShaderInstance)) continue;
            ExtendedShaderInstance extendedShaderInstance = (ExtendedShaderInstance)instance;
            extendedShaderInstance.setUniformDefaults();
        }
    }

    public static void addRenderType(RenderType renderType) {
        boolean isParticle = renderType.f_110133_.contains("particle");
        HashMap<RenderType, BufferBuilder> buffers = isParticle ? PARTICLE_BUFFERS : BUFFERS;
        HashMap<RenderType, BufferBuilder> lateBuffers = isParticle ? LATE_PARTICLE_BUFFERS : LATE_BUFFERS;
        buffers.put(renderType, new BufferBuilder(renderType.m_110507_()));
        lateBuffers.put(renderType, new BufferBuilder(renderType.m_110507_()));
        if (StateShards.NORMAL_TRANSPARENCY.equals(RenderHelper.getTransparencyShard(renderType))) {
            TRANSPARENT_RENDER_TYPES.add(renderType);
        }
    }

    public static void copyDepthBuffer(RenderTarget tempRenderTarget) {
        if (tempRenderTarget == null) {
            return;
        }
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        tempRenderTarget.m_83945_(mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.f_83920_);
    }

    public static class LodestoneRenderLayer {
        protected final HashMap<RenderType, BufferBuilder> buffers;
        protected final HashMap<RenderType, BufferBuilder> particleBuffers;
        protected final MultiBufferSource.BufferSource target;
        protected final MultiBufferSource.BufferSource particleTarget;

        public LodestoneRenderLayer(HashMap<RenderType, BufferBuilder> buffers, HashMap<RenderType, BufferBuilder> particleBuffers) {
            this(buffers, particleBuffers, 256);
        }

        public LodestoneRenderLayer(HashMap<RenderType, BufferBuilder> buffers, HashMap<RenderType, BufferBuilder> particleBuffers, int size) {
            this.buffers = buffers;
            this.particleBuffers = particleBuffers;
            this.target = MultiBufferSource.m_109900_(buffers, (BufferBuilder)new BufferBuilder(size));
            this.particleTarget = MultiBufferSource.m_109900_(particleBuffers, (BufferBuilder)new BufferBuilder(size));
        }

        public HashMap<RenderType, BufferBuilder> getBuffers() {
            return this.buffers;
        }

        public HashMap<RenderType, BufferBuilder> getParticleBuffers() {
            return this.particleBuffers;
        }

        public MultiBufferSource.BufferSource getTarget() {
            return this.target;
        }

        public MultiBufferSource.BufferSource getParticleTarget() {
            return this.particleTarget;
        }
    }
}

