/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class LodestoneAttributeEventHandler {
    public static void processAttributes(LivingHurtEvent event) {
        Entity magicResistance;
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        if (source.m_269150_().m_203656_(LodestoneDamageTypeTags.IS_MAGIC)) {
            LivingEntity attacker;
            AttributeInstance magicProficiency;
            float amount = event.getAmount();
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity && (magicProficiency = (attacker = (LivingEntity)entity).m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_PROFICIENCY.get())) != null && magicProficiency.m_22135_() > 0.0) {
                amount = (float)((double)amount * (1.0 + magicProficiency.m_22135_() * (double)0.1f));
            }
            if ((magicResistance = target.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_RESISTANCE.get())) != null && magicResistance.m_22135_() > 0.0) {
                amount = (float)((double)amount * LodestoneAttributeEventHandler.applyMagicResistance(magicResistance.m_22135_()));
            }
            event.setAmount(amount);
        }
        if ((magicResistance = source.m_7639_()) instanceof LivingEntity) {
            AttributeInstance magicDamage;
            LivingEntity attacker = (LivingEntity)magicResistance;
            if (!source.m_269150_().m_203656_(LodestoneDamageTypeTags.IS_MAGIC) && (magicDamage = attacker.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get())) != null && magicDamage.m_22135_() > 0.0 && !target.m_21224_()) {
                Level level = source.m_7639_().m_9236_();
                Holder.Reference holderOrThrow = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_);
                DamageSource magic = new DamageSource((Holder)holderOrThrow, (Entity)attacker, (Entity)attacker);
                target.f_19802_ = 0;
                target.m_6469_(magic, (float)magicDamage.m_22135_());
            }
        }
    }

    public static double applyMagicResistance(double magicResistance) {
        if (magicResistance >= 20.0) {
            return Math.max(0.25, 0.5 - (magicResistance - 20.0) * (double)0.0125f);
        }
        return 1.0 - magicResistance * (double)0.025f;
    }
}

