/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.systems.item.IEventResponderItem;

public class ItemEventHandler {
    public static void respondToDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        LivingEntity attacker = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity directAttacker;
            attacker = directAttacker = (LivingEntity)entity;
        }
        if (attacker == null) {
            attacker = target.m_21188_();
        }
        if (attacker != null) {
            LivingEntity finalAttacker = attacker;
            ItemHelper.getEventResponders(attacker).forEach(s -> ((IEventResponderItem)s.m_41720_()).killEvent(event, finalAttacker, target, (ItemStack)s));
        }
    }

    public static void respondToHurt(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ItemHelper.getEventResponders(attacker).forEach(s -> ((IEventResponderItem)s.m_41720_()).hurtEvent(event, attacker, target, (ItemStack)s));
            ItemHelper.getEventResponders(target).forEach(s -> ((IEventResponderItem)s.m_41720_()).takeDamageEvent(event, attacker, target, (ItemStack)s));
        }
    }
}

