package team.lodestar.lodestone.systems.datagen.statesmith;

import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;

import java.util.function.Consumer;

public abstract class AbstractBlockStateSmith<T extends Block> {

    public final Class<T> blockClass;

    public AbstractBlockStateSmith(Class<T> blockClass) {
        this.blockClass = blockClass;
    }

    public static class StateSmithData {
        public final LodestoneBlockStateProvider provider;
        public final Consumer<RegistryObject<Block>> consumer;

        public StateSmithData(LodestoneBlockStateProvider provider, Consumer<RegistryObject<Block>> consumer) {
            this.provider = provider;
            this.consumer = consumer;
        }
    }

    public interface StateFunction<T extends Block> {
        void act(T block, ModelFile modelFile);
    }
}