/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import se.mickelus.tetra.TetraToolActions;

public class ToolActionHelper {
    public static final BiMap<ToolAction, TagKey<Block>> appropriateTools = HashBiMap.create((int)5);
    public static final TagKey<Block> hoeExtraTag = BlockTags.create((ResourceLocation)new ResourceLocation("tetra", "hoe_extra_mineable"));
    public static final TagKey<Block> swordVeryEfficient = BlockTags.create((ResourceLocation)new ResourceLocation("tetra", "sword_very_efficient"));
    public static final TagKey<Block> swordInstamine = BlockTags.create((ResourceLocation)new ResourceLocation("tetra", "sword_instamine"));
    public static final Set<TagKey<Block>> cuttingEfficientTags = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_278398_, swordVeryEfficient, swordInstamine});
    public static final TagKey<Block> hammerMineable = BlockTags.create((ResourceLocation)new ResourceLocation("mineable/hammer"));

    public static void init() {
        appropriateTools.put((Object)ToolActions.AXE_DIG, (Object)BlockTags.f_144280_);
        appropriateTools.put((Object)ToolActions.PICKAXE_DIG, (Object)BlockTags.f_144282_);
        appropriateTools.put((Object)ToolActions.SHOVEL_DIG, (Object)BlockTags.f_144283_);
        appropriateTools.put((Object)ToolActions.HOE_DIG, (Object)BlockTags.f_144281_);
        appropriateTools.put((Object)TetraToolActions.hammer, hammerMineable);
    }

    public static Set<ToolAction> getAppropriateTools(BlockState state) {
        return ToolActionHelper.getActionsFor(state).collect(Collectors.toSet());
    }

    @Nullable
    public static ToolAction getAppropriateTool(BlockState state) {
        return ToolActionHelper.getActionsFor(state).findFirst().orElse(null);
    }

    public static boolean isEffectiveOn(ItemStack stack, BlockState state) {
        return ToolActionHelper.getActionsFor(state).anyMatch(arg_0 -> ((ItemStack)stack).canPerformAction(arg_0));
    }

    private static Stream<ToolAction> getActionsFor(BlockState state) {
        return ToolAction.getActions().stream().filter(action -> ToolActionHelper.isEffectiveOn(action, state));
    }

    public static boolean isEffectiveOn(ToolAction action, BlockState state) {
        if (appropriateTools.containsKey((Object)action) && state.m_204336_((TagKey)appropriateTools.get((Object)action))) {
            return true;
        }
        if (TetraToolActions.cut.equals(action)) {
            if (cuttingEfficientTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) {
                return true;
            }
        }
        return ToolActions.HOE_DIG.equals(action) && state.m_204336_(hoeExtraTag);
    }

    public static boolean playerCanDestroyBlock(Player player, BlockState state, BlockPos pos, ItemStack toolStack) {
        return ToolActionHelper.playerCanDestroyBlock(player, state, pos, toolStack, null);
    }

    public static boolean playerCanDestroyBlock(Player player, BlockState state, BlockPos pos, ItemStack toolStack, @Nullable ToolAction useAction) {
        if (state.m_60800_((BlockGetter)player.m_9236_(), pos) < 0.0f) {
            return false;
        }
        if (useAction == null ? !ToolActionHelper.isEffectiveOn(toolStack, state) : !ToolActionHelper.isEffectiveOn(useAction, state)) {
            return false;
        }
        if (!toolStack.m_41735_(state)) {
            return false;
        }
        return ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)state, (boolean)true);
    }
}

