/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.inventory;

import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;

@ParametersAreNonnullByDefault
public class StorageInventory
extends ToolbeltInventory {
    private static final String inventoryKey = "storageInventory";
    public static int maxSize = 36;

    public StorageInventory(ItemStack stack) {
        super(inventoryKey, stack, maxSize, SlotType.storage);
        ModularToolbeltItem item = (ModularToolbeltItem)stack.m_41720_();
        this.numSlots = item.getNumSlots(stack, SlotType.storage);
        this.predicate = StorageInventory.getPredicate("storage");
        this.readFromNBT(stack.m_41784_());
    }

    public static int getColumns(int slotCount) {
        for (int i = 12; i >= 5; --i) {
            if (slotCount % i != 0) continue;
            return i;
        }
        return 9;
    }

    @Override
    public boolean storeItemInInventory(ItemStack itemStack) {
        int i;
        if (!this.isItemValid(itemStack)) {
            return false;
        }
        List<Collection<ItemEffect>> effects = this.getSlotEffects();
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack storedStack = this.m_8020_(i);
            if (!effects.get(i).contains(ItemEffect.quickAccess) || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)storedStack) || storedStack.m_41613_() >= storedStack.m_41741_()) continue;
            int moveCount = Math.min(itemStack.m_41613_(), storedStack.m_41741_() - storedStack.m_41613_());
            storedStack.m_41769_(moveCount);
            this.m_6836_(i, storedStack);
            itemStack.m_41774_(moveCount);
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            if (!effects.get(i).contains(ItemEffect.quickAccess) || !this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }
}

