/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.potion;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import se.mickelus.mutil.effect.EffectTooltipRenderer;
import se.mickelus.tetra.blocks.ArcaneFireBlock;
import se.mickelus.tetra.client.particle.Particles;
import se.mickelus.tetra.util.StreamHelper;
import se.mickelus.tetra.util.StringHelper;

@ParametersAreNonnullByDefault
public class UnstablePowerMobEffect
extends MobEffect {
    public static final String identifier = "unstable_power";
    public static UnstablePowerMobEffect instance;
    private static final int splinterTreshhold = 320;
    public static final float bonusMultiplier = 0.05f;

    public UnstablePowerMobEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xEEEEEE);
        instance = this;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            MobEffectInstance current;
            if (entity.m_9236_().m_46467_() % 80L == 0L && (double)entity.m_9236_().m_213780_().m_188501_() < 0.25 && (current = entity.m_21124_((MobEffect)instance)).m_19557_() >= 320) {
                RandomSource random = entity.m_9236_().m_213780_();
                UnstablePowerMobEffect.findSplinterPosition(entity.m_9236_(), entity.m_20183_()).ifPresent(blockPos -> {
                    if (current.m_19564_() > 0 && random.m_188503_(4) == 0) {
                        UnstablePowerMobEffect.addOrUpdate(entity, 0, -1);
                    } else {
                        UnstablePowerMobEffect.addOrUpdate(entity, -320, 0);
                    }
                    ArcaneFireBlock.spawnDelayed((ServerLevel)entity.m_9236_(), blockPos, entity.m_20183_().m_252807_());
                });
            }
            if (entity.m_9236_().m_46467_() % 20L == 0L && (double)entity.m_9236_().m_213780_().m_188501_() < 0.25) {
                Particles.addSputteringPower((ServerLevel)entity.m_9236_(), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), (Entity)entity);
            }
        }
    }

    private static Optional<BlockPos> findSplinterPosition(Level level, BlockPos origin) {
        BlockState blockState = ((ArcaneFireBlock)((Object)ArcaneFireBlock.instance.get())).m_49966_();
        return BlockPos.m_121985_((BlockPos)origin, (int)6, (int)2, (int)6).map(BlockPos::new).filter(blockPos -> origin.m_123333_((Vec3i)blockPos) > 2).collect(StreamHelper.toShuffledList()).stream().filter(arg_0 -> ((Level)level).m_46859_(arg_0)).filter(blockPos -> blockState.m_60710_((LevelReader)level, blockPos)).findFirst();
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static void addOrUpdate(LivingEntity entity, int duration, int amplifier) {
        MobEffectInstance current = entity.m_21124_((MobEffect)instance);
        int currentAmplifier = Optional.ofNullable(current).map(MobEffectInstance::m_19564_).orElse(0);
        int updatedAmplifier = Math.min(127, currentAmplifier + amplifier);
        int currentDuration = Optional.ofNullable(current).map(MobEffectInstance::m_19557_).orElse(0);
        int updatedDuration = currentDuration + duration;
        if (updatedDuration < currentDuration || updatedAmplifier < currentAmplifier) {
            entity.m_21195_((MobEffect)instance);
        }
        if (updatedDuration > 0 && updatedAmplifier >= 0) {
            entity.m_7292_(new MobEffectInstance((MobEffect)instance, updatedDuration, updatedAmplifier, false, false, true));
        }
    }

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_21023_((MobEffect)instance)) {
            event.setNewSpeed(event.getNewSpeed() * (1.05f + (float)event.getEntity().m_21124_((MobEffect)instance).m_19564_() * 0.05f));
        }
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)instance)) {
            event.setAmount(event.getAmount() * (1.05f + (float)livingEntity.m_21124_((MobEffect)instance).m_19564_() * 0.05f));
        }
    }

    public static void onLivingDeath(Entity killedEntity, Entity killer) {
        LivingEntity livingKilledEntity;
        MobEffectInstance effectInstance;
        if (killedEntity instanceof LivingEntity && (effectInstance = (livingKilledEntity = (LivingEntity)killedEntity).m_21124_((MobEffect)instance)) != null && killer instanceof LivingEntity) {
            LivingEntity livingKiller = (LivingEntity)killer;
            UnstablePowerMobEffect.addOrUpdate(livingKiller, effectInstance.m_19557_(), effectInstance.m_19564_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientMobEffectExtensions)new ClientRenderer());
    }

    static class ClientRenderer
    extends EffectTooltipRenderer {
        private static final int fullBarColor = -1996507772;
        private static final int shadowBarColor = 1442811547;
        int maxDuration = 0;
        float delayedDuration = 0.0f;
        long lastUpdate = 0L;

        public ClientRenderer() {
            super(effect -> I18n.m_118938_((String)"effect.tetra.unstable_power.tooltip", (Object[])new Object[]{(effect.m_19564_() + 1) * 10}));
        }

        public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics guiGraphics, int x, int y, float z, float alpha) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            int duration = Optional.ofNullable(player.m_21124_((MobEffect)UnstablePowerMobEffect.instance)).map(MobEffectInstance::m_19557_).orElse(0);
            int amplifier = Optional.ofNullable(player.m_21124_((MobEffect)UnstablePowerMobEffect.instance)).map(MobEffectInstance::m_19564_).orElse(0);
            if (duration > this.maxDuration || duration == 0) {
                this.maxDuration = duration;
            }
            long time = System.currentTimeMillis();
            if (this.lastUpdate == 0L) {
                this.lastUpdate = time;
            }
            long timeDelta = time - this.lastUpdate;
            float durationDelta = (float)duration - this.delayedDuration;
            this.delayedDuration = durationDelta > 1.0f || durationDelta < -1.0f ? (this.delayedDuration += (float)timeDelta * durationDelta * 0.002f) : (float)duration;
            this.lastUpdate = time;
            float ratio = Mth.m_184631_((float)duration, (float)0.0f, (float)this.maxDuration, (float)0.0f, (float)1.0f);
            float laggedRatio = Mth.m_184631_((float)this.delayedDuration, (float)0.0f, (float)this.maxDuration, (float)0.0f, (float)1.0f);
            ClientRenderer.renderBar(guiGraphics, x, y, Math.min(ratio, laggedRatio), -1996507772);
            ClientRenderer.renderBar(guiGraphics, x, y, Math.max(ratio, laggedRatio), 1442811547);
            ClientRenderer.renderIcon(guiGraphics, x, y, duration);
            ClientRenderer.renderAmplifierLabel(guiGraphics, x, y, amplifier);
            return true;
        }

        private static void renderIcon(GuiGraphics guiGraphics, int x, int y, int duration) {
            float iconAlpha = 1.0f;
            if (duration < 200) {
                int l = 10 - duration / 20;
                iconAlpha = Mth.m_14036_((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)l / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            RenderSystem.enableBlend();
            TextureAtlasSprite textureatlassprite = Minecraft.m_91087_().m_91306_().m_118732_((MobEffect)instance);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, iconAlpha);
            guiGraphics.m_280159_(x + 3, y + 3, 0, 18, 18, textureatlassprite);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }

        private static void renderBar(GuiGraphics guiGraphics, int x, int y, float ratio, int color) {
            if (ratio > 0.0f) {
                ClientRenderer.fill(guiGraphics, x + 10, y + 21, (int)Mth.m_184631_((float)ratio, (float)0.0f, (float)0.125f, (float)0.0f, (float)-7.0f), 1, color);
                if (ratio > 0.125f) {
                    ClientRenderer.fill(guiGraphics, x + 2, y + 21, 1, (int)Mth.m_184631_((float)ratio, (float)0.125f, (float)0.375f, (float)0.0f, (float)-18.0f), color);
                }
                if (ratio > 0.375f) {
                    ClientRenderer.fill(guiGraphics, x + 3, y + 2, (int)Mth.m_184631_((float)ratio, (float)0.375f, (float)0.625f, (float)0.0f, (float)18.0f), 1, color);
                }
                if (ratio > 0.625f) {
                    ClientRenderer.fill(guiGraphics, x + 21, y + 3, 1, (int)Mth.m_184631_((float)ratio, (float)0.625f, (float)0.875f, (float)0.0f, (float)18.0f), color);
                }
                if (ratio > 0.875f) {
                    ClientRenderer.fill(guiGraphics, x + 21, y + 21, (int)Mth.m_184631_((float)ratio, (float)0.875f, (float)1.0f, (float)0.0f, (float)-7.0f), 1, color);
                }
            }
        }

        private static void fill(GuiGraphics graphics, int x, int y, int width, int height, int color) {
            graphics.m_280509_(x + Math.min(width, 0), y + Math.min(height, 0), x + Math.max(width, 0), y + Math.max(height, 0), color);
        }

        private static void renderAmplifierLabel(GuiGraphics guiGraphics, int x, int y, int amplifier) {
            Font font = Minecraft.m_91087_().f_91062_;
            String amplifierText = StringHelper.toRoman(amplifier + 1);
            int xo = 12 - font.m_92895_(amplifierText) / 2;
            guiGraphics.m_280056_(font, amplifierText, x + xo + 1, y + 18, 0x212121, false);
            guiGraphics.m_280056_(font, amplifierText, x + xo - 1, y + 18, 0x212121, false);
            guiGraphics.m_280056_(font, amplifierText, x + xo, y + 19, 0x212121, false);
            guiGraphics.m_280056_(font, amplifierText, x + xo, y + 17, 0x212121, false);
            guiGraphics.m_280056_(font, amplifierText, x + xo, y + 18, 0xFFFFFF, false);
        }
    }
}

