/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.outcome;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.outcome.ItemEffectOutcome;
import se.mickelus.tetra.effect.data.provider.entity.EntityProvider;
import se.mickelus.tetra.effect.data.provider.vector.VectorProvider;

public class ImitateItemEffectOutcome
extends ItemEffectOutcome {
    ItemStack itemStack;
    ImitateType effect;
    EntityProvider targetEntity;
    EntityProvider user;
    VectorProvider targetPosition;

    @Override
    public boolean perform(ItemEffectContext context) {
        switch (this.effect) {
            case swing: {
                return this.swing(context);
            }
            case breakBlockStart: {
                return this.breakBlockStart(context);
            }
            case hurtEnemy: {
                return this.hurtEnemy(context);
            }
            case mineBlock: {
                return this.mineBlock(context);
            }
            case leftClickEntity: {
                return this.leftClickEntity(context);
            }
            case finishUsing: {
                return this.finishUsing(context);
            }
        }
        return false;
    }

    private boolean mineBlock(ItemEffectContext context) {
        Entity entity = this.user.getEntity(context);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos targetPos = this.targetPosition.getBlockPos(context);
            if (targetPos != null) {
                BlockState targetState = context.getLevel().m_8055_(targetPos);
                this.itemStack.m_41686_(context.getLevel(), targetState, targetPos, player);
                return true;
            }
        }
        return false;
    }

    private boolean swing(ItemEffectContext context) {
        Entity entity = this.user.getEntity(context);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return context.getUsedItemStack().onEntitySwing(livingEntity);
        }
        return false;
    }

    private boolean breakBlockStart(ItemEffectContext context) {
        Entity entity = this.user.getEntity(context);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos targetPos = this.targetPosition.getBlockPos(context);
            if (targetPos != null) {
                return this.itemStack.onBlockStartBreak(targetPos, player);
            }
        }
        return false;
    }

    private boolean hurtEnemy(ItemEffectContext context) {
        Entity entity = this.targetEntity.getEntity(context);
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            entity = this.user.getEntity(context);
            if (entity instanceof Player) {
                Player playerAttacker = (Player)entity;
                this.itemStack.m_41640_(livingTarget, playerAttacker);
                return true;
            }
        }
        return false;
    }

    private boolean leftClickEntity(ItemEffectContext context) {
        Entity entity = this.targetEntity.getEntity(context);
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            entity = this.user.getEntity(context);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return this.itemStack.m_41720_().onLeftClickEntity(this.itemStack, player, (Entity)livingTarget);
            }
        }
        return false;
    }

    private boolean finishUsing(ItemEffectContext context) {
        Entity entity = this.user.getEntity(context);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.itemStack.m_41671_(context.getLevel(), (LivingEntity)player);
            return true;
        }
        return false;
    }

    static enum ImitateType {
        swing,
        leftClickEntity,
        hurtEnemy,
        breakBlockStart,
        mineBlock,
        finishUsing;

    }
}

