/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class PunctureEffect
extends ChargedAbilityEffect {
    public static final PunctureEffect instance = new PunctureEffect();

    PunctureEffect() {
        super(20, 0.5, 40, 8.0, ItemEffect.puncture, ChargedAbilityEffect.TargetRequirement.entity, UseAnim.SPEAR, "raised");
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!attacker.m_9236_().f_46443_) {
            int armorBefore = target.m_21230_();
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean isSatiated = !attacker.m_36324_().m_38721_();
            AbilityUseResult result = this.isDefensive(item, itemStack, hand) ? this.performDefensive(attacker, hand, item, itemStack, target) : this.performRegular(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints);
            boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
            attacker.m_36399_(overextended ? 6.0f : 1.0f);
            if (item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration) <= 0 || armorBefore < 6 || target.m_21230_() >= 6) {
                attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack) + target.m_21230_() * 10);
            }
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.performEcho(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints);
            }
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        attacker.m_21011_(hand, false);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    public AbilityUseResult performRegular(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks, boolean isSatiated, int comboPoints) {
        int armor = target.m_21230_();
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 1.0, 0.2f, 0.2f);
        if (result != AbilityUseResult.fail) {
            int momentumLevel;
            boolean reversal;
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            boolean isPunctured = target.m_21124_((MobEffect)PuncturedPotionEffect.instance) != null;
            boolean bl = reversal = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge) > 0 && armor > attacker.m_21230_();
            if (armor < 6 || isPunctured || reversal) {
                int exhilarationLevel;
                double overextendEfficiency;
                double comboLevel;
                int duration = 80;
                if (overchargeBonus > 0) {
                    duration += (int)((float)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge) * 10.0f);
                }
                if ((comboLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                    duration = (int)((double)duration + comboLevel * (double)comboPoints);
                }
                if ((overextendEfficiency = (double)item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend)) > 0.0 && isSatiated) {
                    duration = (int)((double)duration + overextendEfficiency * 20.0);
                }
                if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && isPunctured) {
                    duration += exhilarationLevel;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)BleedingPotionEffect.instance, duration, 1, false, false));
                BleedingPotionEffect.spawnParticles(target, 8);
            }
            if (armor >= 6 && !isPunctured || reversal) {
                int overextendLevel;
                int amplifier = item.getEffectLevel(itemStack, ItemEffect.puncture) - 1;
                int duration = (int)(item.getEffectEfficiency(itemStack, ItemEffect.puncture) * 20.0f);
                if (overchargeBonus > 0) {
                    amplifier += overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge);
                }
                if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0 && isSatiated) {
                    amplifier += overextendLevel;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)PuncturedPotionEffect.instance, duration, amplifier, false, false));
            }
            if (!isPunctured && (momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                double velocity = (double)momentumLevel / 100.0 + (double)(item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum) * (float)armor);
                target.m_5997_(0.0, velocity *= 1.0 - target.m_21133_(Attributes.f_22278_), 0.0);
            }
            target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 0.8f);
        } else {
            target.m_20193_().m_5594_(attacker, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        return result;
    }

    public AbilityUseResult performDefensive(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result;
        boolean isPunctured;
        int armor = target.m_21230_();
        float knockbackMultiplier = 0.3f;
        boolean bl = isPunctured = target.m_21124_((MobEffect)PuncturedPotionEffect.instance) != null;
        if (armor < 6 || isPunctured) {
            knockbackMultiplier += 0.6f;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, 0.3, 0.8f, knockbackMultiplier)) != AbilityUseResult.fail) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0f), item.getEffectLevel(itemStack, ItemEffect.abilityDefensive), false, true));
            target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.8f);
        } else {
            target.m_20193_().m_5594_(attacker, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        return result;
    }

    public void performEcho(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks, boolean isSatiated, int comboPoints) {
        EchoHelper.echo(attacker, 60, () -> this.performRegular(attacker, item, itemStack, target, chargedTicks, isSatiated, comboPoints));
    }
}

