/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class MaterialReductionOutcome
implements CraftingEffectOutcome {
    float probability;
    float diminishingMultiplier = 0.5f;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials, float severity) {
        if (consumeResources && !preMaterials[0].m_41619_() && (ItemStack.m_41656_((ItemStack)preMaterials[0], (ItemStack)postMaterials[0]) || postMaterials[0].m_41619_()) && preMaterials[0].m_41613_() > postMaterials[0].m_41613_()) {
            int usedCount = preMaterials[0].m_41613_() - postMaterials[0].m_41613_();
            float currentProbability = this.probability;
            boolean success = false;
            ItemStack currentMaterialStack = this.getCurrentMaterialStack(postMaterials, preMaterials);
            for (int i = 0; i < usedCount; ++i) {
                if (!(world.m_213780_().m_188501_() < currentProbability)) continue;
                currentMaterialStack.m_41764_(Math.min(currentMaterialStack.m_41613_() + 1, preMaterials[0].m_41613_()));
                currentProbability *= this.diminishingMultiplier;
                success = true;
            }
            if (success) {
                postMaterials[0] = currentMaterialStack;
                return true;
            }
        }
        return false;
    }

    private ItemStack getCurrentMaterialStack(ItemStack[] postMaterials, ItemStack[] preMaterials) {
        if (!postMaterials[0].m_41619_()) {
            return postMaterials[0].m_41777_();
        }
        ItemStack clone = preMaterials[0].m_41777_();
        clone.m_41764_(0);
        return clone;
    }
}

