/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class LightningStrikeOutcome
implements CraftingEffectOutcome {
    int randomOriginDistance = 0;
    int delayTicks = 40;
    float chance = 1.0f;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials, float severity) {
        if (consumeResources && !world.m_5776_() && world.m_213780_().m_188501_() < this.chance) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (this.randomOriginDistance > 0) {
                pos = pos.m_121955_((Vec3i)LightningStrikeOutcome.getRandomOffset(world.m_213780_(), this.randomOriginDistance));
            }
            pos = serverLevel.m_143288_(pos);
            if (this.delayTicks > 0) {
                BlockPos finalPos = pos;
                RandomSource random = world.m_213780_();
                for (int i = 0; i < this.delayTicks; i += 5) {
                    Vec3 particlePos = Vec3.m_82539_((Vec3i)pos).m_82520_(random.m_188583_() * (double)0.3f, (double)(random.m_188501_() * 0.5f), random.m_188583_() * (double)0.3f);
                    int randomDelay = random.m_188503_(4);
                    ServerScheduler.schedule(i + randomDelay, () -> serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 4, 0.0, 0.0, 0.0, 0.0));
                }
                ServerScheduler.schedule(this.delayTicks, () -> LightningStrikeOutcome.spawnLightningBolt(serverLevel, finalPos, (ServerPlayer)player));
            } else {
                LightningStrikeOutcome.spawnLightningBolt(serverLevel, pos, (ServerPlayer)player);
            }
            return true;
        }
        return false;
    }

    private static void spawnLightningBolt(ServerLevel serverLevel, BlockPos pos, ServerPlayer causingPlayer) {
        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
        lightning.m_20219_(Vec3.m_82539_((Vec3i)pos));
        lightning.m_20879_(causingPlayer);
        serverLevel.m_7967_((Entity)lightning);
    }

    private static BlockPos getRandomOffset(RandomSource random, int randomOriginDistance) {
        return new BlockPos(random.m_188503_(randomOriginDistance * 2 + 1) - randomOriginDistance, 0, random.m_188503_(randomOriginDistance * 2 + 1) - randomOriginDistance);
    }
}

