/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.StackContext;

public interface ItemFluidApi {
    public void registerForItem(Supplier<Item> var1);

    public FluidApi.FluidStorage find(StackContext var1);

    default public DataComponentType<FluidStack> getFluidComponent() {
        return ComponentContent.STORED_FLUID.get();
    }

    public static boolean tryFluidBlockItemInteraction(ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand) {
        StackContext stackRef;
        FluidApi.FluidStorage candidate;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof FluidApi.BlockProvider)) {
            return false;
        }
        FluidApi.BlockProvider tankEntity = (FluidApi.BlockProvider)blockEntity;
        ItemStack usedStack = stack;
        if (stack.getCount() > 1) {
            usedStack = stack.copyWithCount(1);
        }
        if ((candidate = FluidApi.ITEM.find(stackRef = new StackContext(usedStack, updated -> {
            if (stack.getCount() > 1) {
                stack.shrink(1);
                if (!player.getInventory().add(updated)) {
                    player.drop(updated, true);
                }
            } else {
                player.setItemInHand(hand, updated);
            }
        }))) == null) {
            return false;
        }
        FluidApi.FluidStorage fluidStorage = tankEntity.getFluidStorage(null);
        if (!world.isClientSide) {
            if (candidate.getContent().getFirst().isEmpty()) {
                long moved = FluidApi.transferLastIncludingInputs(fluidStorage, candidate, FluidStackHooks.bucketAmount() * 8L, false);
                Oritech.LOGGER.debug("moved to item {} {}", (Object)moved, (Object)stackRef.getValue());
            } else {
                long moved = FluidApi.transferFirst(candidate, fluidStorage, FluidStackHooks.bucketAmount() * 8L, false);
                Oritech.LOGGER.debug("moved from item {} {}", (Object)moved, (Object)stackRef.getValue());
            }
        }
        return true;
    }
}

