/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge;

import com.google.auto.service.AutoService;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import dev.technici4n.grandpower.impl.NonLongWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.BlockEnergyApi;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.ItemEnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.StackContext;

@AutoService(value={BlockEnergyApi.class, ItemEnergyApi.class})
public class NeoforgeEnergyApiImpl
implements BlockEnergyApi,
ItemEnergyApi {
    private final List<Supplier<BlockEntityType<?>>> registeredBlockEntities = new ArrayList();
    private final List<Supplier<Item>> registeredItems = new ArrayList<Supplier<Item>>();

    @Override
    public void registerBlockEntity(Supplier<BlockEntityType<?>> typeSupplier) {
        this.registeredBlockEntities.add(typeSupplier);
    }

    @Override
    public void registerForItem(Supplier<Item> itemSupplier) {
        this.registeredItems.add(itemSupplier);
    }

    @Override
    public DataComponentType<Long> getEnergyComponent() {
        return ComponentContent.NEO_ENERGY_COMPONENT.get();
    }

    public void registerEvent(RegisterCapabilitiesEvent event) {
        for (Supplier<BlockEntityType<?>> supplier : this.registeredBlockEntities) {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, supplier.get(), (entity, direction) -> ContainerStorageWrapper.of(((EnergyApi.BlockProvider)entity).getEnergyStorage((Direction)direction)));
        }
        for (Supplier<BlockEntityType<?>> supplier : this.registeredItems) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ignored) -> ContainerStorageWrapper.of(((EnergyApi.ItemProvider)stack.getItem()).getEnergyStorage((ItemStack)stack)), new ItemLike[]{(ItemLike)supplier.get()});
        }
    }

    @Override
    public EnergyApi.EnergyStorage find(StackContext stack) {
        if (stack.getValue().getCount() > 1) {
            return null;
        }
        ILongEnergyStorage candidate = (ILongEnergyStorage)stack.getValue().getCapability(ILongEnergyStorage.ITEM);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            EnergyApi.EnergyStorage energyStorage = wrapper.container;
            if (energyStorage instanceof SimpleEnergyItemStorage) {
                SimpleEnergyItemStorage itemStorage = (SimpleEnergyItemStorage)energyStorage;
                return itemStorage.withCallback(ignored -> stack.sync());
            }
        }
        return new NeoforgeStorageWrapper(candidate);
    }

    @Override
    public EnergyApi.EnergyStorage find(Level world, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        NonLongWrapper outerWrapper;
        IEnergyStorage iEnergyStorage;
        ILongEnergyStorage candidate = (ILongEnergyStorage)world.getCapability(ILongEnergyStorage.BLOCK, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        if (candidate instanceof NonLongWrapper && (iEnergyStorage = (outerWrapper = (NonLongWrapper)candidate).storage()) instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)iEnergyStorage;
            return wrapper.container;
        }
        return new NeoforgeStorageWrapper(candidate);
    }

    @Override
    public EnergyApi.EnergyStorage find(Level world, BlockPos pos, @Nullable Direction direction) {
        return this.find(world, pos, null, null, direction);
    }

    public static class ContainerStorageWrapper
    implements ILongEnergyStorage {
        public final EnergyApi.EnergyStorage container;

        public static ContainerStorageWrapper of(EnergyApi.EnergyStorage container) {
            if (container == null) {
                return null;
            }
            return new ContainerStorageWrapper(container);
        }

        public ContainerStorageWrapper(EnergyApi.EnergyStorage container) {
            this.container = container;
        }

        public long receive(long amount, boolean simulate) {
            long inserted = this.container.insert(amount, simulate);
            if (!simulate) {
                this.container.update();
            }
            return inserted;
        }

        public long extract(long amount, boolean simulate) {
            long inserted = this.container.extract(amount, simulate);
            if (!simulate) {
                this.container.update();
            }
            return inserted;
        }

        public long getAmount() {
            return this.container.getAmount();
        }

        public long getCapacity() {
            return this.container.getCapacity();
        }

        public boolean canExtract() {
            return this.container.supportsExtraction();
        }

        public boolean canReceive() {
            return this.container.supportsInsertion();
        }
    }

    public static class NeoforgeStorageWrapper
    extends EnergyApi.EnergyStorage {
        public final ILongEnergyStorage storage;

        public NeoforgeStorageWrapper(ILongEnergyStorage storage) {
            this.storage = storage;
        }

        @Override
        public long insert(long maxAmount, boolean simulate) {
            return this.storage.receive(maxAmount, simulate);
        }

        @Override
        public long extract(long maxAmount, boolean simulate) {
            return this.storage.extract(maxAmount, simulate);
        }

        @Override
        public long getAmount() {
            return this.storage.getAmount();
        }

        @Override
        public long getCapacity() {
            return this.storage.getCapacity();
        }

        @Override
        public void setAmount(long amount) {
        }

        @Override
        public void update() {
        }
    }
}

