/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.BlockItemApi;
import rearth.oritech.api.item.ItemApi;

public class NeoforgeItemApiImpl
implements BlockItemApi {
    private final List<Supplier<BlockEntityType<?>>> registeredBlockEntities = new ArrayList();

    @Override
    public void registerBlockEntity(Supplier<BlockEntityType<?>> typeSupplier) {
        this.registeredBlockEntities.add(typeSupplier);
    }

    public void registerEvent(RegisterCapabilitiesEvent event) {
        for (Supplier<BlockEntityType<?>> supplied : this.registeredBlockEntities) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, supplied.get(), (entity, direction) -> ContainerStorageWrapper.of(((ItemApi.BlockProvider)entity).getInventoryStorage((Direction)direction)));
        }
    }

    @Override
    public ItemApi.InventoryStorage find(Level world, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        IItemHandler candidate = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        return new NeoforgeStoragerWrapper(candidate);
    }

    @Override
    public ItemApi.InventoryStorage find(Level world, BlockPos pos, @Nullable Direction direction) {
        return this.find(world, pos, null, null, direction);
    }

    public static class ContainerStorageWrapper
    implements IItemHandlerModifiable {
        public final ItemApi.InventoryStorage container;

        public static ContainerStorageWrapper of(ItemApi.InventoryStorage storage) {
            if (storage == null) {
                return null;
            }
            return new ContainerStorageWrapper(storage);
        }

        public ContainerStorageWrapper(ItemApi.InventoryStorage container) {
            this.container = container;
        }

        public int getSlots() {
            return this.container.getSlotCount();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.container.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack arg, boolean simulate) {
            int inserted = this.container.insertToSlot(arg, slot, simulate);
            if (inserted > 0 && !simulate) {
                this.container.update();
            }
            return arg.copyWithCount(arg.getCount() - inserted);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack takenStack = this.container.getStackInSlot(slot).copyWithCount(amount);
            int extracted = this.container.extractFromSlot(takenStack, slot, simulate);
            if (extracted > 0 && !simulate) {
                this.container.update();
            }
            return takenStack.copyWithCount(extracted);
        }

        public int getSlotLimit(int i) {
            return this.container.getSlotLimit(i);
        }

        public boolean isItemValid(int i, @NotNull ItemStack arg) {
            return this.container.insertToSlot(arg, i, true) > 0;
        }

        public void setStackInSlot(int i, @NotNull ItemStack arg) {
            this.container.setStackInSlot(i, arg);
            this.container.update();
        }
    }

    public static class NeoforgeStoragerWrapper
    implements ItemApi.InventoryStorage {
        private final IItemHandler container;

        public NeoforgeStoragerWrapper(IItemHandler candidate) {
            this.container = candidate;
        }

        @Override
        public int insert(ItemStack inserted, boolean simulate) {
            return inserted.getCount() - ItemHandlerHelper.insertItem((IItemHandler)this.container, (ItemStack)inserted, (boolean)simulate).getCount();
        }

        @Override
        public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
            return inserted.getCount() - this.container.insertItem(slot, inserted, simulate).getCount();
        }

        @Override
        public int extract(ItemStack extracted, boolean simulate) {
            int total = 0;
            for (int i = 0; i < this.container.getSlots(); ++i) {
                ItemStack available = this.container.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)available, (ItemStack)extracted)) continue;
                total += this.container.extractItem(i, extracted.getCount() - total, simulate).getCount();
            }
            return total;
        }

        @Override
        public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
            return this.container.extractItem(slot, extracted.getCount(), simulate).getCount();
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            IItemHandler iItemHandler = this.container;
            if (iItemHandler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable handler = (IItemHandlerModifiable)iItemHandler;
                handler.setStackInSlot(slot, stack);
            } else {
                Oritech.LOGGER.error("Unable to set stack in slot: {}, stack is: {}", (Object)slot, (Object)stack);
                Oritech.LOGGER.error("This should never happen");
            }
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.container.getStackInSlot(slot);
        }

        @Override
        public int getSlotCount() {
            return this.container.getSlots();
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.container.getSlotLimit(slot);
        }

        @Override
        public void update() {
        }
    }
}

