/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.init.recipes.RecipeContent;

public class PlayerAugments {
    public static final Map<ResourceLocation, Augment> allAugments = new HashMap<ResourceLocation, Augment>();

    public static void loadAllAugments(RecipeManager manager) {
        allAugments.clear();
        manager.getAllRecipesFor((RecipeType)RecipeContent.AUGMENT_DATA).forEach(recipe -> allAugments.put(recipe.id(), ((AugmentDataRecipe)recipe.value()).createAugment(recipe.id())));
    }

    public static void serverTickAugments(ServerPlayer player) {
        for (Augment augment : allAugments.values()) {
            if (!augment.isEnabled((Player)player) || player.serverLevel().getGameTime() % (long)augment.refreshInterval() != 0L) continue;
            augment.refreshServer((Player)player);
        }
    }

    public static void receiveInstallTrigger(AugmentInstallTriggerPacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity entity = player.level().getBlockEntity(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            AugmentApplicatorOperation operation = AugmentApplicatorOperation.values()[packet.operationId];
            switch (operation.ordinal()) {
                case 0: {
                    modifierEntity.researchAugment(packet.id, player.isCreative(), player);
                    break;
                }
                case 1: {
                    modifierEntity.installAugmentToPlayer(packet.id, player);
                    break;
                }
                case 2: {
                    modifierEntity.removeAugmentFromPlayer(packet.id, player);
                }
            }
        }
    }

    public static void receivePlayerLoadMachine(LoadPlayerAugmentsToMachinePacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity entity = player.level().getBlockEntity(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            modifierEntity.loadResearchesFromPlayer(player);
        }
    }

    public static void receiveOpenAugmentScreen(OpenAugmentScreenPacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity entity = player.level().getBlockEntity(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                modifierEntity.screenInvOverride = true;
                MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)modifierEntity);
            }
        }
    }

    public static void receiveToggleAugment(AugmentPlayerTogglePacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        AugmentApplicationEntity.toggleAugmentForPlayer(packet.id, player);
    }

    public record AugmentInstallTriggerPacket(BlockPos position, ResourceLocation id, int operationId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AugmentInstallTriggerPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("aug_install"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public static enum AugmentApplicatorOperation {
        RESEARCH,
        ADD,
        REMOVE,
        NONE,
        NEEDS_INIT;

    }

    public record LoadPlayerAugmentsToMachinePacket(BlockPos position) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LoadPlayerAugmentsToMachinePacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("aug_loadtomachine"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record OpenAugmentScreenPacket(BlockPos position) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenAugmentScreenPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("aug_openscreen"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record AugmentPlayerTogglePacket(ResourceLocation id) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AugmentPlayerTogglePacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("aug_toggle"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

