/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.client.init.ModRenderers;
import rearth.oritech.client.other.OreFinderRenderer;
import rearth.oritech.client.renderers.BlockOutlineRenderer;
import rearth.oritech.client.renderers.PortalEntityRenderer;
import rearth.oritech.client.renderers.SmallTankItemRenderer;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.init.FluidContent;

@Mod(value="oritech", dist={Dist.CLIENT})
public class OritechClientNeoForge {
    public OritechClientNeoForge(IEventBus eventBus) {
        eventBus.register((Object)new EventHandler());
        OritechClient.initialize();
    }

    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            OritechClient.registerRenderers();
            event.registerEntityRenderer(EntitiesContent.PORTAL_ENTITY, PortalEntityRenderer::new);
            for (Map.Entry<Block, RenderType> entry : ModRenderers.RENDER_LAYERS.entrySet()) {
                ItemBlockRenderTypes.setRenderLayer((Block)entry.getKey(), (RenderType)entry.getValue());
            }
        }

        @SubscribeEvent
        public void initializeClient(RegisterClientExtensionsEvent event) {
            FluidContent.FLUID_ATTRIBUTES.forEach(attribute -> event.registerFluidType(new IClientFluidTypeExtensions(){
                final /* synthetic */ ArchitecturyFluidAttributes val$attribute;
                {
                    this.val$attribute = architecturyFluidAttributes;
                }

                @NotNull
                public ResourceLocation getStillTexture() {
                    return this.val$attribute.getSourceTexture();
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return this.val$attribute.getFlowingTexture();
                }

                public int getTintColor() {
                    return this.val$attribute.getColor();
                }
            }, new FluidType[]{attribute.getSourceFluid().getFluidType()}));
            event.registerItem((IClientItemExtensions)new TankItemExtensions(Oritech.id("tank_item_model")), new Item[]{BlockContent.SMALL_TANK_ITEM});
            event.registerItem((IClientItemExtensions)new TankItemExtensions(Oritech.id("creative_tank_item_model")), new Item[]{BlockContent.CREATIVE_TANK_ITEM});
        }
    }

    private static class TankItemExtensions
    implements IClientItemExtensions {
        private final TankItemRenderer renderer;

        private TankItemExtensions(ResourceLocation modelId) {
            this.renderer = new TankItemRenderer(modelId);
        }

        @NotNull
        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.renderer;
        }
    }

    private static class TankItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final SmallTankItemRenderer itemRenderer;

        public TankItemRenderer(ResourceLocation modelId) {
            super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
            this.itemRenderer = new SmallTankItemRenderer(modelId);
        }

        public void renderByItem(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            this.itemRenderer.render(stack, mode, matrices, vertexConsumers, light, overlay);
        }
    }

    @EventBusSubscriber(modid="oritech", value={Dist.CLIENT})
    public static class CustomEvents {
        @SubscribeEvent
        public static void onWorldRender(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                OreFinderRenderer.doRender(event.getPoseStack(), event.getCamera(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
            }
        }

        @SubscribeEvent
        public static void onOutlineRender(RenderHighlightEvent.Block event) {
            BlockOutlineRenderer.render(Minecraft.getInstance().level, event.getCamera(), event.getPoseStack(), event.getMultiBufferSource());
        }

        @SubscribeEvent
        public static void onMouseLaserInput(InputEvent.MouseButton.Pre event) {
            Minecraft client = Minecraft.getInstance();
            boolean handled = OritechClient.handleMouseClicked(client, event.getButton(), event.getAction(), event.getModifiers());
            if (handled) {
                event.setCanceled(true);
            }
        }
    }
}

