/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmRenderer;

public class AcceleratorControllerRenderer
implements BlockEntityRenderer<AcceleratorControllerBlockEntity> {
    private final Map<AcceleratorControllerBlockEntity, RenderedLine> activeLines = new HashMap<AcceleratorControllerBlockEntity, RenderedLine>();

    public int getViewDistance() {
        return 128;
    }

    public boolean shouldRenderOffScreen(AcceleratorControllerBlockEntity blockEntity) {
        return true;
    }

    public void render(AcceleratorControllerBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.displayTrail == null) {
            this.activeLines.remove(entity);
            return;
        }
        VertexConsumer lineConsumer = vertexConsumers.getBuffer((RenderType)LaserArmRenderer.CUSTOM_LINES);
        float time = (float)entity.getLevel().getGameTime() + tickDelta;
        List<Vec3> displayTrail = entity.displayTrail;
        if (!this.activeLines.containsKey(entity) || !this.activeLines.get((Object)entity).positions.equals(displayTrail)) {
            this.activeLines.put(entity, new RenderedLine(time, displayTrail));
            ParticleContent.PARTICLE_MOVING.spawn(entity.getLevel(), displayTrail.getLast());
        }
        RenderedLine activeLine = this.activeLines.get(entity);
        List<Vec3> line = activeLine.positions;
        float age = time - activeLine.startedAt;
        if (age >= 60.0f && entity.displayTrail.equals(activeLine.positions)) {
            entity.displayTrail = null;
        }
        for (int i = 0; i < line.size() - 1; ++i) {
            Vec3 start = line.get(i).subtract(Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos()));
            Vec3 end = line.get(i + 1).subtract(Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos()));
            Vector3f startPos = new Vector3f((float)start.x, (float)start.y, (float)start.z);
            Vector3f endPos = new Vector3f((float)end.x, (float)end.y, (float)end.z);
            Vec3 camPos = Minecraft.getInstance().cameraEntity.position();
            double camDist = camPos.subtract(line.get(i)).length();
            RenderSystem.lineWidth((float)((float)(40.0 / Math.sqrt(camDist))));
            AcceleratorControllerRenderer.displayLine(matrices, light, overlay, startPos, endPos, lineConsumer, 1.0f);
        }
    }

    private static void displayLine(PoseStack matrices, int light, int overlay, Vector3f startPos, Vector3f endPos, VertexConsumer lineConsumer, float alpha) {
        matrices.pushPose();
        Vector3f cross = new Vector3f((Vector3fc)endPos).sub((Vector3fc)startPos).normalize().cross(0.0f, 1.0f, 0.0f);
        int scaledAlpha = (int)(alpha * 255.0f);
        lineConsumer.addVertex(matrices.last().pose(), startPos.x, startPos.y, startPos.z).setColor(188, 22, 196, scaledAlpha).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        lineConsumer.addVertex(matrices.last().pose(), endPos.x, endPos.y, endPos.z).setColor(188, 22, 196, scaledAlpha).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        lineConsumer.addVertex(matrices.last().pose(), startPos.x, startPos.y, startPos.z).setColor(188, 22, 196, scaledAlpha).setLight(light).setOverlay(overlay).setNormal(cross.x, cross.y, cross.z);
        lineConsumer.addVertex(matrices.last().pose(), endPos.x, endPos.y, endPos.z).setColor(188, 22, 196, scaledAlpha).setLight(light).setOverlay(overlay).setNormal(cross.x, cross.y, cross.z);
        matrices.popPose();
    }

    private record RenderedLine(float startedAt, List<Vec3> positions) {
    }
}

