/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.UpgradableMachineBlockEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.MachineAddonController;

public abstract class UpgradableGeneratorBlockEntity
extends UpgradableMachineBlockEntity {
    @SyncField
    public int currentMaxBurnTime;
    private List<class_1799> pendingOutputs = new ArrayList<class_1799>();
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean isProducingSteam = false;
    @SyncField(value={SyncType.GUI_TICK})
    public final SimpleInOutFluidStorage boilerStorage;

    public UpgradableGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
        this.boilerStorage = new SimpleInOutFluidStorage((long)(Oritech.CONFIG.generators.steamEngineData.steamBoilerCapacityBuckets() * (float)FluidStackHooks.bucketAmount()), this::method_5431){

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                if (!UpgradableGeneratorBlockEntity.this.boilerAcceptsInput(toInsert.getFluid())) {
                    return 0L;
                }
                return super.insert(toInsert, simulate);
            }
        };
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (world.field_9236 || !this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        if (this.progress > 0) {
            if (this.canFitEnergy()) {
                --this.progress;
                this.produceEnergy();
                this.lastWorkedAt = world.method_8510();
                if (this.progress == 0) {
                    this.burningFinished();
                }
                this.method_5431();
            }
        } else if (this.canFitEnergy()) {
            this.tryConsumeInput();
        }
        this.outputEnergy();
    }

    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.boilerStorage.getInStack().getAmount() == 0L || this.boilerStorage.getOutStack().getAmount() >= this.boilerStorage.getCapacity())) {
            return;
        }
        Optional<class_8786<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            int recipeTime;
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().comp_1933();
            this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
            this.currentMaxBurnTime = recipeTime;
            for (int i = 0; i < activeRecipe.getInputs().size(); ++i) {
                class_1799 class_17992 = class_1262.method_5430(this.getInputView(), (int)i, (int)1);
            }
            this.pendingOutputs = activeRecipe.getResults();
            this.method_5431();
        }
    }

    protected void burningFinished() {
        this.produceResultItems();
    }

    protected void produceResultItems() {
        if (!this.pendingOutputs.isEmpty()) {
            for (class_1799 stack : this.pendingOutputs) {
                this.inventory.insert(stack, false);
            }
        }
        this.pendingOutputs.clear();
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.isProducingSteam = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().method_26204() == BlockContent.STEAM_BOILER_ADDON) {
            this.isProducingSteam = true;
            this.field_11863.method_8452(addonBlock.pos(), addonBlock.state().method_26204());
        }
    }

    @Override
    public void updateEnergyContainer() {
        super.updateEnergyContainer();
        long insert = this.energyStorage.maxInsert;
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + insert;
        this.energyStorage.maxInsert = 0L;
    }

    protected boolean canFitEnergy() {
        if (this.isProducingSteam) {
            return true;
        }
        float produced = this.calculateEnergyUsage();
        return (float)this.energyStorage.capacity >= (float)this.energyStorage.amount + produced;
    }

    protected void produceEnergy() {
        float produced = this.calculateEnergyUsage();
        if (this.isProducingSteam) {
            produced *= Oritech.CONFIG.generators.steamEngineData.rfToSteamRatio();
            long extracted = this.boilerStorage.getInputContainer().extract(FluidStack.create((class_3611)class_3612.field_15910.method_15751(), (long)Math.round(produced *= SteamEngineEntity.STEAM_AMOUNT_MULTIPLIER)), false);
            this.boilerStorage.getOutputContainer().insert(FluidStack.create((class_3611)SteamEngineEntity.getUsedSteamFluid(), (long)extracted), false);
        } else {
            this.energyStorage.amount = (long)((float)this.energyStorage.amount + produced);
        }
    }

    @Override
    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * (1.0f / this.getSpeedMultiplier());
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("storedBurn", this.currentMaxBurnTime);
        this.boilerStorage.writeNbt(nbt, "");
        nbt.method_10556("steamAddon", this.isProducingSteam);
        class_2499 resList = new class_2499();
        for (class_1799 stack : this.pendingOutputs) {
            class_2520 data = stack.method_57358(registryLookup);
            resList.add((Object)data);
        }
        nbt.method_10566("pendingResults", (class_2520)resList);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.currentMaxBurnTime = nbt.method_10550("storedBurn");
        this.boilerStorage.readNbt(nbt, "");
        this.isProducingSteam = nbt.method_10577("steamAddon");
        class_2499 storedResults = nbt.method_10554("pendingResults", 10);
        for (class_2520 elem : storedResults) {
            class_2487 compound = (class_2487)elem;
            class_1799 stack = (class_1799)class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)compound).get();
            this.pendingOutputs.add(stack);
        }
    }

    protected abstract Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 var1, class_1937 var2);

    protected void outputEnergy() {
        if (this.energyStorage.getAmount() <= 0L) {
            return;
        }
        long moved = 0L;
        for (class_3545<class_2338, class_2350> target : this.getOutputTargets(this.field_11867, this.field_11863)) {
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.field_11863, (class_2338)target.method_15442(), (class_2350)target.method_15441());
            if (candidate == null) continue;
            moved += EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false).longValue();
        }
        if (moved > 0L) {
            this.method_5431();
        }
    }

    public boolean boilerAcceptsInput(class_3611 fluid) {
        return fluid.equals(class_3612.field_15910);
    }

    @Override
    public float getProgress() {
        return 1.0f - (float)this.progress / (float)this.currentMaxBurnTime;
    }

    public int getCurrentMaxBurnTime() {
        return this.currentMaxBurnTime;
    }

    public void setCurrentMaxBurnTime(int currentMaxBurnTime) {
        this.currentMaxBurnTime = currentMaxBurnTime;
    }

    @Override
    public long getDefaultInsertRate() {
        return 0L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxExtract;
    }

    @Override
    public boolean showEnergy() {
        if (this.energyStorage.maxExtract <= 0L && !this.isProducingSteam) {
            return false;
        }
        return super.showEnergy();
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.currentMaxBurnTime <= 0) {
            return 1.0f;
        }
        int recipeTicks = this.currentMaxBurnTime;
        float animationTicks = 60.0f;
        return animationTicks / (float)recipeTicks * Oritech.CONFIG.generators.animationSpeedMultiplier();
    }
}

