package rearth.oritech.client.renderers;

import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_922;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;

public class SpawnerControllerRenderer implements class_827<SpawnerControllerBlockEntity> {
    
    @Override
    public void render(SpawnerControllerBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        
        if (entity.renderedEntity != null && entity.hasCage) {
            
            matrices.method_22903();
            matrices.method_46416(0, -Math.round(entity.renderedEntity.method_17682() + 0.4f), 0);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(45));
            
            var dispatcher = class_310.method_1551().method_1561();
            
            var renderer = dispatcher.method_3953(entity.renderedEntity);
            
            var progress = Math.min(1f, entity.collectedSouls / (float) entity.maxSouls);
            if (progress != 0)
                progress = (float) LaserArmRenderer.lerp(entity.lastProgress, progress, 0.03f);
            entity.lastProgress = progress;
            
            var color = class_5253.class_5254.method_27764((int) (75 + 180 * progress), (int) (255 * (1f - progress)), 255, 255);
            
            if (renderer instanceof class_922 livingEntityRenderer && entity.renderedEntity instanceof class_1309) {
                
                matrices.method_22905(-1.0F, -1.0F, 1.0F);
                matrices.method_46416(0.0F, -1.501F, 0.0F);
                matrices.method_22905(0.9f, 0.9f, 0.9f);
                var model = livingEntityRenderer.method_4038();
                var renderLayer = class_1921.method_23592(class_2960.method_60656("textures/entity/beacon_beam.png"), true);
                // var renderLayer = RenderLayer.getEndGateway();   // yeah this is fun
                var vertexConsumer = vertexConsumers.getBuffer(renderLayer);
                model.method_2828(matrices, vertexConsumer, light, overlay, color);
            }
            matrices.method_22909();
        }
    }
}
