/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.fabric;

import com.google.auto.service.AutoService;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.BlockItemApi;
import rearth.oritech.api.item.ItemApi;

@AutoService(value={BlockItemApi.class})
public class FabricItemApi
implements BlockItemApi {
    @Override
    public void registerBlockEntity(Supplier<class_2591<?>> typeSupplier) {
        ItemStorage.SIDED.registerForBlockEntity((entity, direction) -> ContainerStorageWrapper.of(((ItemApi.BlockProvider)entity).getInventoryStorage((class_2350)direction)), typeSupplier.get());
    }

    @Override
    public ItemApi.InventoryStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        Storage candidate = (Storage)ItemStorage.SIDED.find(world, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        return new FabricStorageWrapper((Storage<ItemVariant>)candidate);
    }

    @Override
    public ItemApi.InventoryStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return this.find(world, pos, null, null, direction);
    }

    public static class ContainerStorageWrapper
    extends SnapshotParticipant<List<class_1799>>
    implements SlottedStorage<ItemVariant> {
        private final ItemApi.InventoryStorage container;

        public static ContainerStorageWrapper of(ItemApi.InventoryStorage container) {
            if (container == null) {
                return null;
            }
            return new ContainerStorageWrapper(container);
        }

        public ContainerStorageWrapper(ItemApi.InventoryStorage container) {
            this.container = container;
        }

        public boolean supportsInsertion() {
            return this.container.supportsInsertion();
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            return this.container.insert(resource.toStack((int)maxAmount), false);
        }

        public boolean supportsExtraction() {
            return this.container.supportsExtraction();
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            return this.container.extract(resource.toStack((int)maxAmount), false);
        }

        @NotNull
        public Iterator<StorageView<ItemVariant>> iterator() {
            return IntStream.range(0, this.container.getSlotCount()).mapToObj(slot -> new StorageView<ItemVariant>(){

                public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                    this.updateSnapshots(transaction);
                    transaction.addCloseCallback((transactionContext, result) -> {
                        if (result.wasCommitted()) {
                            container.update();
                        }
                    });
                    return container.extractFromSlot(resource.toStack((int)maxAmount), slot, false);
                }

                public boolean isResourceBlank() {
                    return this.getStack().method_7960();
                }

                public ItemVariant getResource() {
                    return ItemVariant.of((class_1799)this.getStack());
                }

                public long getAmount() {
                    return this.getStack().method_7947();
                }

                public long getCapacity() {
                    return container.getSlotLimit(slot);
                }

                private class_1799 getStack() {
                    return container.getStackInSlot(slot);
                }
            }.getUnderlyingView()).iterator();
        }

        protected List<class_1799> createSnapshot() {
            return IntStream.range(0, this.container.getSlotCount()).mapToObj(slot -> this.container.getStackInSlot(slot).method_7972()).toList();
        }

        protected void readSnapshot(List<class_1799> snapshot) {
            IntStream.range(0, snapshot.size()).forEach(slot -> this.container.setStackInSlot(slot, (class_1799)snapshot.get(slot)));
        }

        public int getSlotCount() {
            return this.container.getSlotCount();
        }

        public SingleSlotStorage<ItemVariant> getSlot(final int i) {
            return new SingleStackStorage(){

                protected class_1799 getStack() {
                    return container.getStackInSlot(i);
                }

                protected void setStack(class_1799 stack) {
                    container.setStackInSlot(i, stack);
                }

                protected void onFinalCommit() {
                    super.onFinalCommit();
                    container.update();
                }
            };
        }
    }

    public static class FabricStorageWrapper
    implements ItemApi.InventoryStorage {
        public final Storage<ItemVariant> storage;

        public FabricStorageWrapper(Storage<ItemVariant> storage) {
            this.storage = storage;
        }

        @Override
        public boolean supportsInsertion() {
            return this.storage.supportsInsertion();
        }

        @Override
        public int insert(class_1799 inserted, boolean simulate) {
            if (inserted.method_7960()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                long insertCount = this.storage.insert((Object)ItemVariant.of((class_1799)inserted), (long)inserted.method_7947(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                int n = (int)insertCount;
                return n;
            }
        }

        @Override
        public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
            if (inserted.method_7960()) {
                return 0;
            }
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                try (Transaction transaction = Transaction.openOuter();){
                    long insertCount = slottedStorage.getSlot(slot).insert((Object)ItemVariant.of((class_1799)inserted), (long)inserted.method_7947(), (TransactionContext)transaction);
                    if (!simulate) {
                        transaction.commit();
                    }
                    int n = (int)insertCount;
                    return n;
                }
            }
            return 0;
        }

        @Override
        public boolean supportsExtraction() {
            return this.storage.supportsExtraction();
        }

        @Override
        public int extract(class_1799 extracted, boolean simulate) {
            if (extracted.method_7960()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                long extractedCount = this.storage.extract((Object)ItemVariant.of((class_1799)extracted), (long)extracted.method_7947(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                int n = (int)extractedCount;
                return n;
            }
        }

        @Override
        public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
            if (extracted.method_7960()) {
                return 0;
            }
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                try (Transaction transaction = Transaction.openOuter();){
                    long extractedCount = slottedStorage.getSlot(slot).extract((Object)ItemVariant.of((class_1799)extracted), (long)extracted.method_7947(), (TransactionContext)transaction);
                    if (!simulate) {
                        transaction.commit();
                    }
                    int n = (int)extractedCount;
                    return n;
                }
            }
            return 0;
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack) {
            Oritech.LOGGER.error("Unable to set stack in slot: {}, stack is: {}", (Object)slot, (Object)stack);
            Oritech.LOGGER.error("This should never happen");
        }

        @Override
        public class_1799 getStackInSlot(int slot) {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return ((ItemVariant)slottedStorage.getSlot(slot).getResource()).toStack((int)slottedStorage.getSlot(slot).getAmount());
            }
            return class_1799.field_8037;
        }

        @Override
        public int getSlotCount() {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return slottedStorage.getSlotCount();
            }
            return 1;
        }

        @Override
        public int getSlotLimit(int slot) {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return (int)slottedStorage.getSlot(slot).getCapacity();
            }
            return 0;
        }

        @Override
        public void update() {
        }
    }
}

