/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.addons;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

public class CombiAddonBlock
extends MachineAddonBlock {
    public CombiAddonBlock(class_4970.class_2251 settings, MachineAddonBlock.AddonSettings addonSettings) {
        super(settings, addonSettings);
    }

    @Override
    @NotNull
    public Class<? extends class_2586> getBlockEntityType() {
        return CombiAddonEntity.class;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862;
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.method_8608() && itemStack.method_57826((class_9331)ComponentContent.ADDON_DATA.get()) && (class_25862 = world.method_8321(pos)) instanceof CombiAddonEntity) {
            CombiAddonEntity combiAddonEntity = (CombiAddonEntity)class_25862;
            combiAddonEntity.storedData = (ShrinkerBlockEntity.ShrunkAddonData)itemStack.method_57824((class_9331)ComponentContent.ADDON_DATA.get());
        }
    }

    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        boolean showExtra = class_437.method_25441();
        if (showExtra) {
            if (!stack.method_57826((class_9331)ComponentContent.ADDON_DATA.get())) {
                return;
            }
            ShrinkerBlockEntity.ShrunkAddonData data = (ShrinkerBlockEntity.ShrunkAddonData)stack.method_57824((class_9331)ComponentContent.ADDON_DATA.get());
            ArrayList<class_2561> foundTexts = CombiAddonBlock.getShrinkTooltip(data);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.combi_addon_desc").method_27692(class_124.field_1080));
            tooltip.addAll(foundTexts);
        }
    }

    @NotNull
    public static ArrayList<class_2561> getShrinkTooltip(ShrinkerBlockEntity.ShrunkAddonData data) {
        int displayedNumber;
        MachineAddonController.BaseAddonData usedSettings = data.data();
        ArrayList<class_2561> foundTexts = new ArrayList<class_2561>();
        if (usedSettings.speed() != 1.0f) {
            displayedNumber = Math.round((1.0f / usedSettings.speed() - 1.0f) * 100.0f);
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_speed_desc").method_27692(class_124.field_1063).method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        if (usedSettings.efficiency() != 1.0f) {
            displayedNumber = Math.round((1.0f - usedSettings.efficiency()) * 100.0f);
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_efficiency_desc").method_27692(class_124.field_1063).method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        if (usedSettings.energyBonusCapacity() != 0L) {
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_capacity_desc").method_27692(class_124.field_1063).method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusCapacity(), " RF")));
        }
        if (usedSettings.energyBonusTransfer() != 0L) {
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_transfer_desc").method_27692(class_124.field_1063).method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusTransfer(), " RF/t")));
        }
        if (usedSettings.maxBurstTicks() != 0) {
            foundTexts.add((class_2561)class_2561.method_43469((String)"tooltip.oritech.addon_combi_burst", (Object[])new Object[]{usedSettings.maxBurstTicks()}).method_27692(class_124.field_1080));
        }
        if (data.cropFilter()) {
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_combi_crop").method_27692(class_124.field_1080));
        }
        if (data.fluid()) {
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_combi_fluid").method_27692(class_124.field_1080));
        }
        if (data.quarryCount() > 0) {
            foundTexts.add((class_2561)class_2561.method_43469((String)"tooltip.oritech.addon_combi_quarry", (Object[])new Object[]{data.quarryCount()}).method_27692(class_124.field_1080));
        }
        if (data.yieldCount() > 0) {
            foundTexts.add((class_2561)class_2561.method_43469((String)"tooltip.oritech.addon_combi_yield", (Object[])new Object[]{data.yieldCount()}).method_27692(class_124.field_1080));
        }
        if (data.silk()) {
            foundTexts.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_combi_silk").method_27692(class_124.field_1080));
        }
        return foundTexts;
    }
}

