package rearth.oritech.fabric;

import com.google.auto.service.AutoService;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.util.StackContext;
import rearth.oritech.api.energy.BlockEnergyApi;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.ItemEnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import team.reborn.energy.api.EnergyStorage;
import java.util.function.Supplier;

@AutoService({BlockEnergyApi.class, ItemEnergyApi.class})
public class FabricEnergyApiImpl implements BlockEnergyApi, ItemEnergyApi {
    
    @Override
    public void registerBlockEntity(Supplier<class_2591<?>> typeSupplier) {
        team.reborn.energy.api.EnergyStorage.SIDED.registerForBlockEntity((entity, direction) ->
                                                     ContainerStorageWrapper.of(((EnergyApi.BlockProvider) entity).getEnergyStorage(direction)), typeSupplier.get());
    }
    
    @Override
    public void registerForItem(Supplier<net.minecraft.class_1792> itemSupplier) {
        team.reborn.energy.api.EnergyStorage.ITEM.registerForItems((stack, context) ->
                                              ContainerStorageWrapper.of(((EnergyApi.ItemProvider) stack.method_7909()).getEnergyStorage(stack), context, stack), itemSupplier.get());
    }
    
    @Override
    public class_9331<Long> getEnergyComponent() {
        return team.reborn.energy.api.EnergyStorage.ENERGY_COMPONENT;
    }
    
    @Override
    public EnergyApi.EnergyStorage find(StackContext stack) {
        if (stack.getValue().method_7947() > 1) return null;
        var context = ContainerItemContext.ofSingleSlot(new ItemStackStorage(stack));
        var candidate = team.reborn.energy.api.EnergyStorage.ITEM.find(stack.getValue(), context);
        if (candidate == null) return null;
        if (candidate instanceof ContainerStorageWrapper wrapper && wrapper.container instanceof SimpleEnergyItemStorage itemStorage)
            return itemStorage.withCallback(ignored -> stack.sync());
        return new FabricStorageWrapper(candidate, stack);
    }
    
    @Override
    public EnergyApi.EnergyStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        var candidate = team.reborn.energy.api.EnergyStorage.SIDED.find(world, pos, state, entity, direction);
        if (candidate == null) return null;
        if (candidate instanceof ContainerStorageWrapper wrapper) return wrapper.container;
        return new FabricStorageWrapper(candidate, null);
    }
    
    @Override
    public EnergyApi.EnergyStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return find(world, pos, null, null, direction);
    }
    
    // this is used to interact with energy storages from other mods
    public static class FabricStorageWrapper extends EnergyApi.EnergyStorage {
        
        public final EnergyStorage storage;
        public final @Nullable StackContext context;
        
        public FabricStorageWrapper(EnergyStorage storage, @Nullable StackContext context) {
            this.storage = storage;
            this.context = context;
        }
        
        @Override
        public long insert(long maxAmount, boolean simulate) {
            try (var transaction = Transaction.openOuter()) {
                var inserted = storage.insert(maxAmount, transaction);
                if (!simulate)
                    transaction.commit();
                return inserted;
            }
        }
        
        @Override
        public long extract(long maxAmount, boolean simulate) {
            try (var transaction = Transaction.openOuter()) {
                var extracted = storage.extract(maxAmount, transaction);
                if (!simulate)
                    transaction.commit();
                return extracted;
            }
        }
        
        @Override
        public long getAmount() {
            return storage.getAmount();
        }
        
        @Override
        public long getCapacity() {
            return storage.getCapacity();
        }
        
        @Override
        public void setAmount(long amount) {
        }
        
        @Override
        public void update() {
            if (context != null)
                context.sync();
        }
    }
    
    // this is used by other mods to interact with the oritech energy containers (machines/items)
    public static class ContainerStorageWrapper extends SnapshotParticipant<Long> implements EnergyStorage {
        
        public final EnergyApi.EnergyStorage container;
        @Nullable
        public final ContainerItemContext context;
        @Nullable
        public final class_1799 stack;
        
        public static ContainerStorageWrapper of(@Nullable EnergyApi.EnergyStorage container) {
            if (container == null) return null;
            return new ContainerStorageWrapper(container);
        }
        
        public static ContainerStorageWrapper of(@Nullable EnergyApi.EnergyStorage container, @Nullable ContainerItemContext context, @Nullable class_1799 stack) {
            if (container == null) return null;
            return new ContainerStorageWrapper(container, context, stack);
        }
        
        public ContainerStorageWrapper(EnergyApi.EnergyStorage container) {
            this.container = container;
            this.context = null;
            this.stack = null;
        }
        
        public ContainerStorageWrapper(EnergyApi.EnergyStorage container, @Nullable ContainerItemContext context, @Nullable class_1799 stack) {
            this.container = container;
            this.context = context;
            this.stack = stack;
        }
        
        @Override
        public boolean supportsInsertion() {
            return container.supportsInsertion();
        }
        
        @Override
        public long insert(long maxAmount, TransactionContext transaction) {
            updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    container.update();
                }
            });
            
            var inserted = container.insert(maxAmount, false);
            
            // no idea what this does, but it does seem to fix it
            if (context != null) {
                stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), container.getAmount());
                context.exchange(ItemVariant.of(stack), 1, transaction);
            }
            
            
            return inserted;
        }
        
        @Override
        public boolean supportsExtraction() {
            return container.supportsInsertion();
        }
        
        @Override
        public long extract(long maxAmount, TransactionContext transaction) {
            updateSnapshots(transaction);
            transaction.addCloseCallback((context, result) -> {
                if (result.wasCommitted()) {
                    container.update();
                }
            });

            var extracted = container.extract(maxAmount, false);

            // no idea what this does, but it does seem to fix it
            if (context != null) {
                stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), container.getAmount());
                context.exchange(ItemVariant.of(stack), 1, transaction);
            }

            return extracted;
        }
        
        @Override
        public long getAmount() {
            return container.getAmount();
        }
        
        @Override
        public long getCapacity() {
            return container.getCapacity();
        }
        
        @Override
        protected Long createSnapshot() {
            return getAmount();
        }
        
        @Override
        protected void readSnapshot(Long snapshot) {
            container.setAmount(snapshot);
        }
    }
    
}
