package rearth.oritech.item.tools.armor;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.client.renderers.ExosuitArmorRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5712;
import net.minecraft.class_572;
import net.minecraft.class_6880;

// this item can store both energy and fluids
// applicable fluids will be consumed first, and then energy
// the fluid bar is rendered in a different color if a fluid is available
public class JetpackElytraItem extends class_1738 implements GeoItem, BaseJetpackItem {
    
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    
    public JetpackElytraItem(class_6880<class_1741> material, class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }
    
    @Override
    public boolean requireTakeoff() {
        return false;
    }
    
    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        
        if (world.field_9236 && class_310.method_1551().field_1724.method_6128()) {
            tickJetpack(stack, entity, world);
        }
    }
    
    public boolean useCustomElytra(class_1309 entity, class_1799 chestStack, boolean tickElytra) {
        if (!tickElytra) return true;
        
        int nextRoll = entity.method_6003() + 1;
        if (!entity.method_37908().field_9236 && nextRoll % 10 == 0) {
            entity.method_32876(class_5712.field_28158);
        }
        
        return true;
    }
    
    // this overrides the IItemExtension methods in neoforge
    public boolean canElytraFly(class_1799 stack, class_1309 entity) {
        return useCustomElytra(entity, entity.method_6118(class_1304.field_6174), true);
    }
    
    public boolean elytraFlightTick(class_1799 stack, class_1309 entity, int flightTicks) {
        return true;
    }
    
    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return getJetpackBarColor(stack);
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        return getJetpackBarStep(stack);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var hint = class_2561.method_43471("tooltip.oritech.jetpack_usage").method_27695(class_124.field_1080, class_124.field_1056);
        tooltip.add(hint);
        hint = class_2561.method_43471("tooltip.oritech.jetpack_usage2").method_27695(class_124.field_1080, class_124.field_1056);
        tooltip.add(hint);
        addJetpackTooltip(stack, tooltip, true);
    }
    
    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider() {
            private GeoArmorRenderer<?> renderer;
            
            @Override
            public @Nullable <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                
                if (this.renderer == null)
                    this.renderer = new ExosuitArmorRenderer(Oritech.id("armor/basic_jetpack"), Oritech.id("armor/basic_jetpack"));
                
                return this.renderer;
            }
        });
    }
    
    // Let's add our animation controller
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, 20, state -> PlayState.STOP));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
    
    @Override
    public boolean requireUpward() {
        return true;
    }
    
    @Override
    public float getSpeed() {
        return Oritech.CONFIG.elytraJetpack.speed();
    }
    
    @Override
    public int getRfUsage() {
        return (int) Oritech.CONFIG.elytraJetpack.energyUsage();
    }
    
    @Override
    public int getFuelUsage() {
        return Oritech.CONFIG.elytraJetpack.fuelUsage();
    }
    
    @Override
    public long getFuelCapacity() {
        return Oritech.CONFIG.elytraJetpack.fuelCapacity();
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.elytraJetpack.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.elytraJetpack.chargeSpeed();
    }
}
