package rearth.oritech.fabric;

import com.google.auto.service.AutoService;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.BlockFluidApi;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.api.item.BlockItemApi;
import rearth.oritech.api.item.ItemApi;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;

@AutoService({BlockItemApi.class})
public class FabricItemApi implements BlockItemApi {
    
    @Override
    public void registerBlockEntity(Supplier<class_2591<?>> typeSupplier) {
        ItemStorage.SIDED.registerForBlockEntity((entity, direction) ->
                                                   ContainerStorageWrapper.of(((ItemApi.BlockProvider) entity).getInventoryStorage(direction)), typeSupplier.get());
    }
    
    @Override
    public ItemApi.InventoryStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        var candidate = ItemStorage.SIDED.find(world, pos, state, entity, direction);
        if (candidate == null) return null;
        if (candidate instanceof ContainerStorageWrapper wrapper) return wrapper.container;
        return new FabricStorageWrapper(candidate);
    }
    
    @Override
    public ItemApi.InventoryStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return find(world, pos, null, null, direction);
    }
    
    // used to interact with storages from other mods
    public static class FabricStorageWrapper implements ItemApi.InventoryStorage {
        
        public final Storage<ItemVariant> storage;
        
        public FabricStorageWrapper(Storage<ItemVariant> storage) {
            this.storage = storage;
        }
        
        @Override
        public boolean supportsInsertion() {
            return storage.supportsInsertion();
        }
        
        @Override
        public int insert(class_1799 inserted, boolean simulate) {
            if (inserted.method_7960()) return 0;
            try (var transaction = Transaction.openOuter()) {
                var insertCount = storage.insert(ItemVariant.of(inserted), inserted.method_7947(), transaction);
                if (!simulate)
                    transaction.commit();
                return (int) insertCount;
            }
        }
        
        @Override
        public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
            if (inserted.method_7960()) return 0;
            
            // this usually won't be used
            if (storage instanceof SlottedStorage<ItemVariant> slottedStorage) {
                try (var transaction = Transaction.openOuter()) {
                    var insertCount = slottedStorage.getSlot(slot).insert(ItemVariant.of(inserted), inserted.method_7947(), transaction);
                    if (!simulate)
                        transaction.commit();
                    return (int) insertCount;
                }
                
            }
            
            return 0;
        }
        
        @Override
        public boolean supportsExtraction() {
            return storage.supportsExtraction();
        }
        
        @Override
        public int extract(class_1799 extracted, boolean simulate) {
            if (extracted.method_7960()) return 0;
            try (var transaction = Transaction.openOuter()) {
                var extractedCount = storage.extract(ItemVariant.of(extracted), extracted.method_7947(), transaction);
                if (!simulate)
                    transaction.commit();
                return (int) extractedCount;
            }
        }
        
        @Override
        public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
            if (extracted.method_7960()) return 0;
            
            if (storage instanceof SlottedStorage<ItemVariant> slottedStorage) {
                try (var transaction = Transaction.openOuter()) {
                    var extractedCount = slottedStorage.getSlot(slot).extract(ItemVariant.of(extracted), extracted.method_7947(), transaction);
                    if (!simulate)
                        transaction.commit();
                    return (int) extractedCount;
                }
                
            }
            
            return 0;
        }
        
        @Override
        public void setStackInSlot(int slot, class_1799 stack) {
            Oritech.LOGGER.error("Unable to set stack in slot: {}, stack is: {}", slot, stack);
            Oritech.LOGGER.error("This should never happen");
        }
        
        @Override
        public class_1799 getStackInSlot(int slot) {
            // this usually won't be used
            
            if (storage instanceof SlottedStorage<ItemVariant> slottedStorage) {
                return slottedStorage.getSlot(slot).getResource().toStack((int) slottedStorage.getSlot(slot).getAmount());
            }
            
            return class_1799.field_8037;
        }
        
        @Override
        public int getSlotCount() {
            
            if (storage instanceof SlottedStorage<ItemVariant> slottedStorage) {
                return slottedStorage.getSlotCount();
            }
            
            return 1;
        }
        
        @Override
        public int getSlotLimit(int slot) {
            
            if (storage instanceof SlottedStorage<ItemVariant> slottedStorage) {
                return (int) slottedStorage.getSlot(slot).getCapacity();
            }
            
            return 0;
        }
        
        @Override
        public void update() {
        
        }
    }
    
    // this is used by other mods to interact with oritech storages
    public static class ContainerStorageWrapper extends SnapshotParticipant<List<class_1799>> implements SlottedStorage<ItemVariant> {
        
        private final ItemApi.InventoryStorage container;
        
        public static ContainerStorageWrapper of(ItemApi.InventoryStorage container) {
            if (container == null) return null;
            return new ContainerStorageWrapper(container);
        }
        
        public ContainerStorageWrapper(ItemApi.InventoryStorage container) {
            this.container = container;
        }
        
        @Override
        public boolean supportsInsertion() {
            return container.supportsInsertion();
        }
        
        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    container.update();
                }
            });
            
            return container.insert(resource.toStack((int) maxAmount), false);
        }
        
        @Override
        public boolean supportsExtraction() {
            return container.supportsExtraction();
        }
        
        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    container.update();
                }
            });
            
            return container.extract(resource.toStack((int) maxAmount), false);
        }
        
        @Override
        public @NotNull Iterator<StorageView<ItemVariant>> iterator() {
            return IntStream.range(0, container.getSlotCount()).mapToObj(slot -> new StorageView<ItemVariant>() {
                @Override
                public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                    updateSnapshots(transaction);
                    transaction.addCloseCallback((transactionContext, result) -> {
                        if (result.wasCommitted()) {
                            container.update();
                        }
                    });
                    
                    return container.extractFromSlot(resource.toStack((int) maxAmount), slot, false);
                }
                
                @Override
                public boolean isResourceBlank() {
                    return getStack().method_7960();
                }
                
                @Override
                public ItemVariant getResource() {
                    return ItemVariant.of(getStack());
                }
                
                @Override
                public long getAmount() {
                    return getStack().method_7947();
                }
                
                @Override
                public long getCapacity() {
                    return container.getSlotLimit(slot);
                }
                
                private class_1799 getStack() {
                    return container.getStackInSlot(slot);
                }
                
            }.getUnderlyingView()).iterator();
        }
        
        @Override
        protected List<class_1799> createSnapshot() {
            return IntStream.range(0, container.getSlotCount()).mapToObj(slot -> container.getStackInSlot(slot).method_7972()).toList();
        }
        
        @Override
        protected void readSnapshot(List<class_1799> snapshot) {
            IntStream.range(0, snapshot.size()).forEach(slot -> container.setStackInSlot(slot, snapshot.get(slot)));
        }
        
        @Override
        public int getSlotCount() {
            return container.getSlotCount();
        }
        
        @Override
        public SingleSlotStorage<ItemVariant> getSlot(int i) {
            return new SingleStackStorage() {
                @Override
                protected class_1799 getStack() {
                    return container.getStackInSlot(i);
                }
                
                @Override
                protected void setStack(class_1799 stack) {
                    container.setStackInSlot(i, stack);
                }
                
                @Override
                protected void onFinalCommit() {
                    super.onFinalCommit();
                    container.update();
                }
            };
        }
    }
    
    
    
}
