package rearth.oritech;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.init.ModRenderers;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.AugmentSelectionScreen;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.util.Helpers;


public final class OritechClient {
    
    public static final class_304 AUGMENT_SELECTOR = new class_304("key.oritech.augment_screen", GLFW.GLFW_KEY_G, "key.categories.misc");
    
    public static AugmentSelectionScreen activeScreen = null;
    
    public static boolean laserActive = false;
    
    public static void initialize() {
        
        Oritech.LOGGER.info("Oritech client initialization");
        ModScreens.registerScreens();
        
        KeyMappingRegistry.register(AUGMENT_SELECTOR);
        
        // used mainly for prometheum pick
        ClientTickEvent.CLIENT_PRE.register(Helpers::onClientTickEvent);
        
        // used for augment UI
        ClientTickEvent.CLIENT_PRE.register(client -> {
            
            if (PlayerAugments.allAugments.isEmpty() && client.field_1687 != null)
                PlayerAugments.loadAllAugments(client.field_1687.method_8433());
            
            if (AUGMENT_SELECTOR.method_1436() && activeScreen == null) {
                activeScreen = new AugmentSelectionScreen();
                client.method_1507(activeScreen);
            } else if (activeScreen != null && !class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), AUGMENT_SELECTOR.field_1655.method_1444())) {
                activeScreen.method_25419();
            }
        });
        
        ClientTickEvent.CLIENT_PRE.register(client -> {
            var player = client.field_1724;
            if (player == null) return;
            
            for (var augment : PlayerAugments.allAugments.values()) {
                if (augment.isEnabled(player))
                    augment.refreshClient(player);
            }
        });
        
        // send mining laser use events to server
        ClientTickEvent.CLIENT_PRE.register(client -> {
            if (client.field_1724 != null && client.field_1724.method_6047().method_7909() instanceof PortableLaserItem && laserActive) {
                NetworkManager.sendToServer(new PortableLaserItem.LaserPlayerUsePacket());
            } else {
                laserActive = false;
            }
        });
        
        // interrupt left mouse for portable lasers (only seems to work on fabric)
        ClientRawInputEvent.MOUSE_CLICKED_PRE.register((client, button, action, mods) ->
                                                         handleMouseClicked(client, button, action, mods) ? EventResult.interruptTrue() : EventResult.pass());
        
        Oritech.LOGGER.info("Oritech client initialization done");
    }
    
    // returns true if the event is cancelled
    public static boolean handleMouseClicked(class_310  client, int button, int action, int mods) {
        if (client.field_1724 != null && client.field_1724.method_6047().method_7909() instanceof PortableLaserItem && button == 0 && client.field_1755 == null) {
            laserActive = action == 1; // activate laser on mouse down
            return action == 1;
        }
        return false;
    }
    
    public static void registerRenderers() {
        
        Oritech.LOGGER.info("Registering oritech renderers");
        ModRenderers.registerRenderers();
    }
}