/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.init;

import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import rearth.oritech.Oritech;

public class ParticleContent {
    public static final ParticleSystemController PARTICLE_CONTROLLER = new ParticleSystemController(Oritech.id("particles"));
    public static final ParticleSystem<Void> HIGHLIGHT_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((class_2394)class_2398.field_29644, pos, 1.0f, 120, 6);
        ClientParticles.reset();
    });
    public static final ParticleSystem<LineData> WEED_KILLER = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> {
        int dist = (int)data.end.method_1022(data.start);
        ClientParticles.setParticleCount((int)(dist * 4 + world.field_9229.method_43048(3)));
        ClientParticles.spawnLine((class_2394)class_2398.field_11216, (class_1937)world, (class_243)data.start, (class_243)data.end, (float)0.2f);
    });
    public static final ParticleSystem<Void> DEBUG_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((class_2394)class_2398.field_29644, pos, 1.0f, 120, 2);
        ClientParticles.reset();
    });
    public static final ParticleSystem<SoulParticleData> WANDERING_SOUL = PARTICLE_CONTROLLER.register(SoulParticleData.class, (world, pos, data) -> {
        ClientParticles.setVelocity((class_243)data.offset.method_1021((double)(1.0f / (float)data.duration * 1.5f)));
        ClientParticles.spawnWithMaxAge((class_2394)class_2398.field_38002, (class_243)pos, (int)data.duration);
    });
    public static final ParticleSystem<class_243> LASER_BOOM = PARTICLE_CONTROLLER.register(class_243.class, (world, pos, data) -> {
        int count = (int)(pos.method_1022(data) * (double)0.6f + 1.0);
        count = Math.min(count, 12);
        ParticleContent.spawnLineInnerStaggered((class_2394)class_2398.field_38908, world, pos, data, count, 20L);
    });
    public static final ParticleSystem<LineData> CATALYST_CONNECTION = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> ClientParticles.spawnEnchantParticles((class_1937)world, (class_243)data.start, (class_243)data.end, (float)0.7f));
    public static final ParticleSystem<class_243> BLACK_HOLE_EMISSION = PARTICLE_CONTROLLER.register(class_243.class, (world, pos, data) -> {
        int dist = (int)data.method_1022(pos);
        ClientParticles.setParticleCount((int)(dist + world.field_9229.method_43048(3)));
        ClientParticles.spawnLine((class_2394)class_2398.field_38004, (class_1937)world, (class_243)pos, (class_243)data, (float)0.2f);
    });
    public static final ParticleSystem<Integer> FERTILIZER_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnWithinBlock((class_2394)class_2398.field_11211, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
    });
    public static final ParticleSystem<Integer> BLOCK_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_22246, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.6);
    });
    public static final ParticleSystem<Integer> QUARRY_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_22246, (class_1937)world, (class_243)pos, (double)0.4);
    });
    public static final ParticleSystem<Integer> UNSTABLE_CONTAINER_GROWING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_47493, (class_1937)world, (class_243)pos, (double)4.0);
    });
    public static final ParticleSystem<Integer> WATERING_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_18306, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.6);
    });
    public static final ParticleSystem<Integer> FURNACE_BURNING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_11239, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.6);
    });
    public static final ParticleSystem<Integer> PULVERIZER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_46763, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.6);
    });
    public static final ParticleSystem<Integer> SOUL_USED = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_11211, (class_1937)world, (class_243)pos, (double)1.2);
    });
    public static final ParticleSystem<Integer> MELTDOWN_IMMINENT = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_11239, (class_1937)world, (class_243)pos, (double)1.0);
    });
    public static final ParticleSystem<Integer> GRINDER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_46763, (class_1937)world, (class_243)pos, (double)0.8);
    });
    public static final ParticleSystem<Integer> ASSEMBLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_11208, (class_1937)world, (class_243)pos, (double)0.6);
    });
    public static final ParticleSystem<Integer> COOLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_28013, (class_1937)world, (class_243)pos, (double)1.2);
    });
    public static final ParticleSystem<Integer> STEAM_ENGINE_WORKING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawn((class_2394)class_2398.field_11204, (class_1937)world, (class_243)pos, (double)0.6);
    });
    public static final ParticleSystem<Integer> CHARGING = PARTICLE_CONTROLLER.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)data);
        ClientParticles.spawnCenteredOnBlock((class_2394)class_2398.field_38908, (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.6);
    });
    public static final ParticleSystem<Void> BIG_HIT = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawn((class_2394)class_2398.field_38908, (class_1937)world, (class_243)pos, (double)0.3));
    public static final ParticleSystem<Void> PARTICLE_COLLIDE = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawn((class_2394)class_2398.field_47494, (class_1937)world, (class_243)pos, (double)0.0));
    public static final ParticleSystem<class_243> JETPACK_EXHAUST = PARTICLE_CONTROLLER.register(class_243.class, (world, pos, data) -> {
        ClientParticles.setVelocity((class_243)data);
        ClientParticles.spawn((class_2394)class_2398.field_11251, (class_1937)world, (class_243)pos, (double)0.1);
    });
    public static final ParticleSystem<Void> ACCELERATING = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ParticleContent.spawnCubeOutline((class_2394)class_2398.field_38004, pos, 1.0f, 5, 3);
        ClientParticles.reset();
    });
    public static final ParticleSystem<Void> LASER_BEAM_EFFECT = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)1);
        ClientParticles.spawnPrecise((class_2394)class_2398.field_27783, (class_1937)world, (class_243)pos, (double)0.4, (double)0.3, (double)0.4);
    });
    public static final ParticleSystem<Void> PARTICLE_MOVING = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> ClientParticles.spawnPrecise((class_2394)class_2398.field_23190, (class_1937)world, (class_243)pos, (double)0.2, (double)0.3, (double)0.2));

    private static void spawnCubeOutline(class_2394 particle, class_243 origin, float size, int duration, int segments) {
        ParticleContent.spawnLineInner(particle, origin, origin.method_1031((double)size, 0.0, 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.method_1031(0.0, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031((double)size, 0.0, (double)size), segments, duration);
        origin = origin.method_1031(0.0, (double)size, 0.0);
        ParticleContent.spawnLineInner(particle, origin, origin.method_1031((double)size, 0.0, 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.method_1031(0.0, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031((double)size, 0.0, (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin, origin.method_1031(0.0, (double)(-size), 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, (double)(-size), 0.0), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031(0.0, (double)(-size), (double)size), segments, duration);
        ParticleContent.spawnLineInner(particle, origin.method_1031((double)size, 0.0, (double)size), origin.method_1031((double)size, (double)(-size), (double)size), segments, duration);
    }

    private static void spawnLineInner(class_2394 particle, class_243 start, class_243 end, float particleCount, int duration) {
        class_243 increment = end.method_1020(start).method_1021((double)(1.0f / particleCount));
        int i = 0;
        while ((float)i < particleCount) {
            ClientParticles.spawnWithMaxAge((class_2394)particle, (class_243)start, (int)duration);
            start = start.method_1019(increment);
            ++i;
        }
    }

    private static void spawnLineInnerStaggered(class_2394 particle, class_1937 world, class_243 start, class_243 end, float particleCount, long pauseMillis) {
        class_243 increment = end.method_1020(start).method_1021((double)(1.0f / particleCount));
        CompletableFuture.runAsync(() -> {
            int i = 0;
            while ((float)i < particleCount) {
                class_243 pos = start.method_1019(increment.method_1021((double)i));
                world.method_8406(particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
                try {
                    Thread.sleep(pauseMillis);
                }
                catch (InterruptedException e) {
                    break;
                }
                ++i;
            }
        });
    }

    public static void registerParticles() {
        Oritech.LOGGER.debug("Registering Oritech particles");
    }

    public record LineData(class_243 start, class_243 end) {
    }

    public record SoulParticleData(class_243 offset, int duration) {
    }
}

