package rearth.oritech.item.tools.armor;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.item.tools.util.OritechEnergyItem;

import rearth.oritech.util.TooltipHelper;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

import static rearth.oritech.item.tools.harvesting.ChainsawItem.BAR_STEP_COUNT;


public interface BaseJetpackItem extends OritechEnergyItem, FluidApi.ItemProvider {
    
    boolean requireUpward();
    int getRfUsage();
    int getFuelUsage();
    long getFuelCapacity();
    float getSpeed();
    
    default boolean requireTakeoff() {return true;}
    
    default void tickJetpack(class_1799 stack, class_1297 entity, class_1937 world) {
        
        if (!(entity instanceof class_1657 player)) return;
        
        var isEquipped = player.method_6118(class_1304.field_6174).equals(stack);
        if (!isEquipped) return;
        
        var client = class_310.method_1551();
        
        var up = client.field_1690.field_1903.method_1434();
        var forward = client.field_1690.field_1894.method_1434();
        var backward = client.field_1690.field_1881.method_1434();
        var left = client.field_1690.field_1913.method_1434();
        var right = client.field_1690.field_1849.method_1434();
        
        var horizontal = forward || backward || left || right;
        var upOnly = up && !horizontal;
        
        var isActive = up;
        if (!requireUpward()) isActive = up || horizontal;
        
        if (requireTakeoff() && !isJetpackStarted(player, world, up)) return;
        
        if (!isActive || player.method_24828() || player.method_5869()) return;
        
        var powerMultiplier = getSpeed();
        
        // try using energy/fuel
        if (tryUseFluid(stack)) {
            powerMultiplier *= 2.5f;
        } else if (!tryUseEnergy(stack, getRfUsage(), player)) {
            return;
        }
        
        if (up) {
            processUpwardsMotion(player, powerMultiplier, upOnly);
        } else {
            powerMultiplier *= 0.7f;    // slower forward while not going up
        }
        
        if (forward || backward)
            processForwardMotion(player, forward, powerMultiplier);
        
        if (left || right)
            processSideMotion(player, right, powerMultiplier);
        
        var fluidStack = getStoredFluid(stack);
        var fluid = class_7923.field_41173.method_10221(fluidStack.getFluid());
        
        // this will currently only for instances of this class
        NetworkManager.sendToServer(new JetpackItem.JetpackUsageUpdatePacket(getStoredEnergy(stack), fluid.toString(), fluidStack.getAmount()));
        
        var playerForward = player.method_5663();
        var playerRight = playerForward.method_1029().method_1024(-90);
        var particleCenter = player.method_33571().method_1031(0, -1.1, 0).method_1020(playerForward.method_1021(0.2f));
        var particlePosA = particleCenter.method_1019(playerRight.method_1021(0.4f));
        var particlePosB = particleCenter.method_1019(playerRight.method_1021(-0.4f));
        
        var direction = new class_243(0, -1, 0);
        if (forward) direction = playerForward.method_1029().method_1021(-1).method_1031(0, -1, 0);
        
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosA, direction);
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosB, direction);
    }
    
    private static boolean isJetpackStarted(class_1657 player, class_1937 world, boolean up) {
        
        var grounded = player.method_24828() || player.method_5869();
        
        if (grounded) {
            JetpackItem.LAST_GROUND_CONTACT = world.method_8510();
            JetpackItem.PRESSED_SPACE = false;
            return false;
        } else {
            var flightTime = world.method_8510() - JetpackItem.LAST_GROUND_CONTACT;
            
            if (flightTime < 5) return false;
            if (up) JetpackItem.PRESSED_SPACE = true;
            
            return JetpackItem.PRESSED_SPACE;
        }
    }
    
    private static void processUpwardsMotion(class_1657 player, float powerMultiplier, boolean upOnly) {
        var velocity = player.method_60478();
        
        var verticalMultiplier = LaserArmRenderer.lerp(powerMultiplier, 1, 0.6f);
        var power = 0.13f * verticalMultiplier;
        var dampeningFactor = 1.7f;
        
        if (!upOnly) power *= 0.7f;
        
        var speed = Math.max(velocity.field_1351, 0.8);
        var addedVelocity = power / Math.pow(speed, dampeningFactor);
        
        player.method_18799(velocity.method_1031(0, addedVelocity, 0));
    }
    
    private static void processSideMotion(class_1657 player, boolean right, float powerMultiplier) {
        var modifier = right ? 1 : -1;  // either go full speed ahead, or slowly backwards
        var power = 0.04f * powerMultiplier;
        
        // get existing movement
        var movement = player.method_60478();
        var horizontalMovement = new class_243(movement.field_1352, 0, movement.field_1350);
        
        // get player facing
        var playerForward = player.method_5663();
        playerForward = new class_243(playerForward.field_1352, 0, playerForward.field_1350).method_1029();
        var playerRight = playerForward.method_1024(-90);
        
        // apply forward / back
        horizontalMovement = horizontalMovement.method_1019(playerRight.method_1021(modifier * power));
        
        player.method_18800(horizontalMovement.field_1352, movement.field_1351, horizontalMovement.field_1350);
    }
    
    private static void processForwardMotion(class_1657 player, boolean forward, float powerMultiplier) {
        var modifier = forward ? 1f : -0.4;  // either go full speed ahead, or slowly backwards
        var power = 0.06f * powerMultiplier;
        
        // get existing movement
        var movement = player.method_60478();
        var horizontalMovement = new class_243(movement.field_1352, 0, movement.field_1350);
        
        // get player facing
        var playerForward = player.method_5663();
        playerForward = new class_243(playerForward.field_1352, 0, playerForward.field_1350).method_1029();
        
        // apply forward / back
        horizontalMovement = horizontalMovement.method_1019(playerForward.method_1021(modifier * power));
        
        player.method_18800(horizontalMovement.field_1352, movement.field_1351, horizontalMovement.field_1350);
    }
    
    default boolean tryUseFluid(class_1799 stack) {
        var fluidStack = getStoredFluid(stack);
        if (fluidStack.getAmount() < getFuelUsage() || !isValidFuel(fluidStack.getFluid()))
            return false;
        var res = FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount() - getFuelUsage());
        stack.method_57379(ComponentContent.STORED_FLUID.get(), res);
        return true;
    }
    
    default FluidStack getStoredFluid(class_1799 stack) {
        return stack.method_57825(ComponentContent.STORED_FLUID.get(), FluidStack.empty());
    }
    
    default void addJetpackTooltip(class_1799 stack, List<class_2561> tooltip, boolean includeEnergy) {
        
        var text = class_2561.method_43469("tooltip.oritech.energy_indicator", TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack)));
        if (includeEnergy) tooltip.add(text.method_27692(class_124.field_1065));
        
        var container = getStoredFluid(stack);
        var fluidText = class_2561.method_43469("tooltip.oritech.jetpack_fuel", container.getAmount() * 1000 / FluidStackHooks.bucketAmount(), getFuelCapacity() * 1000 / FluidStackHooks.bucketAmount(), FluidStackHooks.getName(container).getString());
        tooltip.add(fluidText);
    }
    
    default int getJetpackBarColor(class_1799 stack) {
        
        var fluidStack = getStoredFluid(stack);
        if (fluidStack.getAmount() > getFuelUsage() && isValidFuel(fluidStack.getFluid())) {
            return 0xbafc03;
        }
        
        return 0xff7007;
    }
    
    default int getJetpackBarStep(class_1799 stack) {
        
        var fluidStack = getStoredFluid(stack);
        if (fluidStack.getAmount() > getFuelUsage() && isValidFuel(fluidStack.getFluid())) {
            var fillPercent = fluidStack.getAmount() * 100 / getFuelCapacity();
            return Math.round(fillPercent * BAR_STEP_COUNT) / 100;
        }
        
        return Math.round((getStoredEnergy(stack) * 100f / this.getEnergyCapacity(stack)) * BAR_STEP_COUNT) / 100;
    }
    
    default boolean isValidFuel(class_3611 variant) {
        return variant.method_15780(FluidContent.STILL_FUEL.get());
    }
    
    @Override
    default FluidApi.SingleSlotStorage getFluidStorage(class_1799 stack) {
        return new SimpleItemFluidStorage(getFuelCapacity(), stack) {
            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                var valid = isValidFuel(toInsert.getFluid());
                if (!valid) return 0L;
                return super.insert(toInsert, simulate);
            }
        };
    }
}
