package rearth.oritech.block.blocks.generators;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.PassiveGeneratorBlock;
import rearth.oritech.block.entity.generators.BigSolarPanelEntity;

import rearth.oritech.util.MultiblockMachineController;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3965;
import net.minecraft.class_437;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class BigSolarPanelBlock extends PassiveGeneratorBlock {
    
    public final int productionRate;
    
    public BigSolarPanelBlock(class_2251 settings, int productionRate) {
        super(settings);
        this.productionRate = productionRate;
        method_9590(method_9564().method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED);
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BigSolarPanelEntity(pos, state);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof BigSolarPanelEntity solarPanel)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = solarPanel.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = solarPanel.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                solarPanel.triggerSetupAnimation();
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
            } else {
                solarPanel.sendInfoMessageToPlayer(player);
            }
            return class_1269.field_5812;
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        addMachineTooltip(tooltip, this, this);
        if (class_437.method_25441())
            tooltip.add(class_2561.method_43471("tooltip.oritech.solar_generation").method_27692(class_124.field_1080));
    }
}
