package rearth.oritech.fabric;

import com.google.auto.service.AutoService;
import com.mojang.authlib.GameProfile;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.util.TriConsumer;
import rearth.oritech.Oritech;
import rearth.oritech.OritechPlatform;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.util.fabric.FakeMachinePlayerImpl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

@AutoService(OritechPlatform.class)
public class OritechPlatformFabric implements OritechPlatform {

    // Network
    public static final Queue<Runnable> PENDING_S2C_INITS = new ArrayDeque<>();
    
    @Override
    public void sendBlockHandle(class_2586 blockEntity, class_8710 message) {
        for (var player : PlayerLookup.tracking(blockEntity)) {
            ServerPlayNetworking.send(player, message);
        }
    }

    @Override
    public void sendPlayerHandle(class_8710 message, class_3222 player) {
        ServerPlayNetworking.send(player, message);
    }

    @Override
    public void sendToServer(class_8710 message) {
        ClientPlayNetworking.send(message);
    }

    @Override
    public <T extends class_8710> void registerToClient(
        class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec,
        TriConsumer<T, class_1937, class_5455> consumer
    ) {
        PayloadTypeRegistry.playS2C().register(id, packetCodec);

        PENDING_S2C_INITS.add(() -> {
                ClientPlayNetworking.registerGlobalReceiver(id, (message, context) -> {
                    consumer.accept(message, context.player().field_17892, context.client().field_1687.method_30349());
                });
            }
        );
    }

    @Override
    public <T extends class_8710> void registerToServer(
        class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec,
        TriConsumer<T, class_1657, class_5455> consumer
    ) {
        PayloadTypeRegistry.playC2S().register(id, packetCodec);
        ServerPlayNetworking.registerGlobalReceiver(id, (message, context) -> {
            consumer.accept(message, context.player(), context.player().method_51469().method_30349());
        });
    }
    
    // Attachment

    private static final Map<class_2960, AttachmentType<?>> REGISTERED_TYPES = new HashMap<>();

    @Override
    public <T> void register(Attachment<T> attachment) {
        var created = AttachmentRegistry.<T>builder()
            .copyOnDeath()
            .initializer(attachment.initializer())
            .persistent(attachment.persistenceCodec())
            .syncWith(attachment.networkCodec(), AttachmentSyncPredicate.targetOnly())
            .buildAndRegister(attachment.identifier());

        REGISTERED_TYPES.put(attachment.identifier(), created);
    }

    @Override
    public <T> boolean hasAttachment(class_1309 entity, Attachment<T> attachment) {
        var type = REGISTERED_TYPES.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Querying attachment that has not been registered: {}", attachment.identifier());
            return false;
        }
        return entity.hasAttached(type);
    }

    @Override
    public <T> T getAttachmentValue(class_1309 entity, Attachment<T> attachment) {
        AttachmentType<T> type = (AttachmentType<T>) REGISTERED_TYPES.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Getting attachment that has not been registered: {}", attachment.identifier());
            return null;
        }
        return entity.getAttachedOrCreate(type);
    }

    @Override
    public <T> void setAttachment(class_1309 entity, Attachment<T> attachment, T value) {
        AttachmentType<T> type = (AttachmentType<T>) REGISTERED_TYPES.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Setting attachment that has not been registered: {}", attachment.identifier());
            return;
        }
        entity.setAttached(type, value);
    }

    @Override
    public <T> void removeAttachment(class_1309 entity, Attachment<T> attachment) {
        var type = REGISTERED_TYPES.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Removing attachment that has not been registered: {}", attachment.identifier());
            return;
        }
        entity.removeAttached(type);
    }

    // FakeMachinePlayer
    @Override
    public class_3222 create(class_3218 world, GameProfile profile, SimpleInventoryStorage inventory) {
        return FakeMachinePlayerImpl.create(world, profile, inventory);
    }
    
    @Override
    public void resetCapabilities(class_3218 world, class_2338 pos) {
        // nothing to do on fabric
    }
}
