package rearth.oritech.block.blocks.pipes;

import org.apache.commons.lang3.function.TriFunction;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.item.tools.Wrench;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public abstract class GenericPipeDuctBlock extends AbstractPipeBlock implements Wrench.Wrenchable {

	public GenericPipeDuctBlock(class_2251 settings) {
		super(settings);
	}

	@Override
	protected class_265 getShape(class_2680 state) {
		return class_259.method_1077();
	}

	@Override
	protected class_265[] createShapes() {
		return new class_265[0];
	}

	@Override
	public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
		if (oldState.method_26204().equals(state.method_26204())) return;

		updateNeighbors(world, pos, true);
		// no states need to be added (see getPlacementState)
		GenericPipeInterfaceEntity.addNode(world, pos, false, state, getNetworkData(world));
	}

	@Override
	public void updateNeighbors(class_1937 world, class_2338 pos, boolean neighborToggled) {
		for (var direction : class_2350.values()) {
			var neighborPos = pos.method_10093(direction);
			var neighborState = world.method_8320(neighborPos);
			// Only update pipes
			if (neighborState.method_26204() instanceof AbstractPipeBlock pipeBlock) {
				var updatedState = pipeBlock.addConnectionStates(neighborState, world, neighborPos, neighborToggled);
				world.method_8501(neighborPos, updatedState);

				// Update network data if the state was changed
				if (!neighborState.equals(updatedState)) {
					boolean interfaceBlock = updatedState.method_27852(getConnectionBlock().method_26204());
					//if (neighborToggled)
						//GenericPipeInterfaceEntity.addNode(world, neighborPos, interfaceBlock, updatedState, getNetworkData(world));
				}
			}
		}
	}

	@Override
	public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
		return state;
	}

	@Override
	public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection) {
		return state;
	}

	@Override
	public class_2680 addStraightState(class_2680 state) {
		return state;
	}

	@Override
	public boolean shouldConnect(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
		return true;
	}

	@Override
	public boolean isConnectingInDirection(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
		var neighborPos = currentPos.method_10093(direction);
		var neighborState = world.method_8320(neighborPos);
		if (neighborState.method_26215()) {
			return false;
		} else if (neighborState.method_26204() instanceof GenericPipeDuctBlock pipeBlock) {
			return true;
		} else if (neighborState.method_26204() instanceof AbstractPipeBlock pipeBlock) {
			return pipeBlock.isConnectingInDirection(neighborState, direction.method_10153(), neighborPos, world, createConnection);
		}

		return true;
	}

	@Override
	public TriFunction<class_1937, class_2338, class_2350, Boolean> apiValidationFunction() {
		return ((world, pos, direction) -> false);
	}

	@Override
	protected void onBlockRemoved(class_2338 pos, class_2680 oldState, class_1937 world) {
		updateNeighbors(world, pos, false);
		GenericPipeInterfaceEntity.removeNode(world, pos, false, oldState, getNetworkData(world));
	}

	@Override
	public class_1269 onWrenchUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
		if (player.method_5715()) {
			world.method_8651(pos, true, player);
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}
	
	@Override
	public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
		super.method_9568(stack, context, tooltip, options);
		tooltip.add(class_2561.method_43471("tooltip.oritech.pipe_duct_warning").method_27695(class_124.field_1080, class_124.field_1056));
	}
	
	@Override
	public class_1269 onWrenchUseNeighbor(class_2680 state, class_2680 neighborState, class_1937 world, class_2338 pos, class_2338 neighborPos, class_2350 neighborFace, class_1657 player, class_1268 hand) {
		return class_1269.field_5811;
	}
}
