package rearth.oritech.block.blocks.pipes;

import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;

public abstract class AbstractPipeBlock extends class_2248 {
    
    private static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightCableHitboxes();
    protected class_265[] boundingShapes;
    
    public AbstractPipeBlock(class_2251 settings) {
        super(settings);
        this.boundingShapes = createShapes();
    }
    
    protected abstract class_265 getShape(class_2680 state);
    
    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!USE_ACCURATE_OUTLINES)
            return super.method_9530(state, world, pos, context);
        return getShape(state);
    }
    
    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return getShape(state);
    }
    
    protected abstract class_265[] createShapes();
    
    @Override
    public abstract void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify);
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var baseState = addFluidState(super.method_9605(ctx), ctx.method_8037(), ctx.method_8045());
        return addConnectionStates(baseState, ctx.method_8045(), ctx.method_8037(), true);
    }
    
    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 worldAccess, class_2338 pos, class_2338 neighborPos) {
        var world = (class_1937) worldAccess;
        if (world.field_9236) return state;
        
        if (neighborState.method_27852(class_2246.field_10124))
            // remove potential stale machine -> neighboring pipes mapping
            getNetworkData(world).machinePipeNeighbors.remove(neighborPos);
        
        return state;
    }
    
    public class_2680 addFluidState(class_2680 state, class_2338 pos, class_1937 level) {
        return state.method_11657(class_2741.field_12508, level.method_8316(pos).method_39360(class_3612.field_15910));
    }
    
    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        
        if (!state.method_27852(newState.method_26204()) && !(newState.method_26204() instanceof AbstractPipeBlock)) {
            // block was removed/replaced instead of updated
            onBlockRemoved(pos, state, world);
        }
        
    }
    
    /**
     * Updates all the neighboring pipes of the target position.
     *
     * @param world           The target world
     * @param pos             The target position
     * @param neighborToggled Whether the neighbor was toggled
     */
    public abstract void updateNeighbors(class_1937 world, class_2338 pos, boolean neighborToggled);
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!player.method_7337() && !world.field_9236) {
            onBlockRemoved(pos, state, world);
        }
        return super.method_9576(world, pos, state, player);
    }
    
    /**
     * Adds the connection states to the pipe block-state.
     *
     * @param state            The current pipe block-state
     * @param world            The target world
     * @param pos              The target pipe position
     * @param createConnection Whether to create a connection
     * @return The updated block-state
     */
    public abstract class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection);
    
    /**
     * Adds the connection states to the pipe block-state.
     * Attempts to create a connection ONLY in the specified direction.
     * Useful for when only one connection needs to be created.
     *
     * @param state           The current pipe block-state
     * @param world           The target world
     * @param pos             The target pipe position
     * @param createDirection The direction to create a connection in
     * @return The updated block-state
     */
    public abstract class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection);
    
    /**
     * Adds the straight property to the pipe block-state.
     *
     * @param state The current pipe block-state
     * @return The updated block-state
     */
    public abstract class_2680 addStraightState(class_2680 state);
    
    /**
     * Check if the pipe should connect in a specific direction.
     *
     * @param current          The current pipe block-state
     * @param direction        The direction to check
     * @param currentPos       The current pipe position
     * @param world            The target world
     * @param createConnection Whether to create a connection
     * @return Boolean whether the pipe should connect
     */
    public abstract boolean shouldConnect(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection);
    
    /**
     * Check if the pipe is connecting in a specific direction.
     *
     * @param current          The target pipe block-state
     * @param direction        The direction to check
     * @param createConnection Whether to create a connection
     * @return Boolean whether the pipe is connecting
     */
    public abstract boolean isConnectingInDirection(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection);
    
    /**
     * Check if the pipe node has a neighboring machine.
     *
     * @param state The target pipe block-state
     * @param world The target world
     * @param pos   The target pipe position
     * @return Boolean whether a machine is connected
     */
    public boolean hasNeighboringMachine(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
        var lookup = apiValidationFunction();
        return (isConnectingInDirection(state, class_2350.field_11043, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11043, world, pos, lookup))
                 || (isConnectingInDirection(state, class_2350.field_11034, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11034, world, pos, lookup))
                 || (isConnectingInDirection(state, class_2350.field_11035, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11035, world, pos, lookup))
                 || (isConnectingInDirection(state, class_2350.field_11039, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11039, world, pos, lookup))
                 || (isConnectingInDirection(state, class_2350.field_11036, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11036, world, pos, lookup))
                 || (isConnectingInDirection(state, class_2350.field_11033, pos, world, createConnection) && hasMachineInDirection(class_2350.field_11033, world, pos, lookup));
    }
    
    /**
     * Check if a machine is connected in a specific direction.
     *
     * @param direction The direction to check
     * @param world     The target world
     * @param ownPos    The target pipe position
     * @param lookup    The lookup function {@link AbstractPipeBlock#apiValidationFunction()}
     * @return Boolean whether a machine is connected
     */
    public boolean hasMachineInDirection(class_2350 direction, class_1937 world, class_2338 ownPos, TriFunction<class_1937, class_2338, class_2350, Boolean> lookup) {
        var neighborPos = ownPos.method_10081(direction.method_10163());
        var neighborState = world.method_8320(neighborPos);
        return !(neighborState.method_26204() instanceof GenericPipeBlock) && lookup.apply(world, neighborPos, direction.method_10153());
    }
    
    /**
     * Check if the target block is a valid connection target.
     *
     * @param target    The target block
     * @param world     The target world
     * @param direction The direction to check (IMPORTANT: This is the direction from the target to the current pipe)
     * @param pos       The target pipe position
     * @return Boolean whether the target is a valid connection target
     */
    public boolean isValidConnectionTarget(class_2248 target, class_1937 world, class_2350 direction, class_2338 pos) {
        var lookupFunction = apiValidationFunction();
        return connectToOwnBlockType(target) || (lookupFunction.apply(world, pos, direction) && isCompatibleTarget(target));
    }
    
    /**
     * Check if the target block is a valid interface target.
     *
     * @param target    The target block
     * @param world     The target world
     * @param direction The direction to check (IMPORTANT: This is the direction from the target to the current pipe)
     * @param pos       The target pipe position
     * @return Boolean whether the target is a valid interface target
     */
    public boolean isValidInterfaceTarget(class_2248 target, class_1937 world, class_2350 direction, class_2338 pos) {
        var lookupFunction = apiValidationFunction();
        return (lookupFunction.apply(world, pos, direction) && isCompatibleTarget(target));
    }
    
    /**
     * Check if the target block is compatible with the pipe block.
     *
     * @param block The target block
     * @return Boolean whether the block is compatible
     */
    public boolean isCompatibleTarget(class_2248 block) {
        return true;
    }
    
    /**
     * Validation function which utilizes lookup API's to check if a block is a valid connection target.
     *
     * @return The validation function for the pipe block
     */
    public abstract TriFunction<class_1937, class_2338, class_2350, Boolean> apiValidationFunction();
    
    public abstract class_2680 getConnectionBlock();
    
    public abstract class_2680 getNormalBlock();
    
    public abstract String getPipeTypeName();
    
    public abstract boolean connectToOwnBlockType(class_2248 block);
    
    public abstract GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(class_1937 world);
    
    protected abstract void onBlockRemoved(class_2338 pos, class_2680 oldState, class_1937 world);
}
