package rearth.oritech.block.blocks.accelerator;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5558;

public class AcceleratorControllerBlock extends class_2383 implements class_2343 {
    public AcceleratorControllerBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Override
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AcceleratorControllerBlockEntity(pos, state);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236 && world.method_8321(pos) instanceof AcceleratorControllerBlockEntity accelerator) {
            MenuRegistry.openExtendedMenu((class_3222) player, accelerator);
        }
        
        return class_1269.field_5812;
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        var showExtra = class_437.method_25441();
        if (!showExtra) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.accelerator").method_27692(class_124.field_1080));
        }
    }
}
