package rearth.oritech.init.world.features.resourcenode;

import com.mojang.serialization.Codec;
import rearth.oritech.Oritech;

import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3756;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class ResourceNodeFeature extends class_3031<ResourceNodeFeatureConfig> {
    
    public ResourceNodeFeature(Codec<ResourceNodeFeatureConfig> configCodec) {
        super(configCodec);
    }
    
    @Override
    public boolean method_13151(class_5821<ResourceNodeFeatureConfig> context) {

        var world = context.method_33652();
        var origin = context.method_33655();
        
        if (world.method_8608()) return false;
        
        var solidBlockFound = false;
        var testPos = new class_2338(origin);
        var deepNodePos = testPos;
        var boulderPos = testPos;

        for (int y = origin.method_10264(); y > world.method_31607(); y--) {
            var downPos = testPos.method_10074();
            var testState = world.method_8320(downPos);
            if (testState.method_27852(class_2246.field_9987)) {
                deepNodePos = testPos;
                break;
            } else if (testState.method_26212(world, downPos) && !solidBlockFound) {
                boulderPos = testPos = downPos;
                solidBlockFound = true;
            } else {
                testPos = downPos;
            }
        }

        // edge case: if no solid block was found, or the boulder is too close to the deep node, don't generate
        if (!solidBlockFound || boulderPos.method_10264() < (deepNodePos.method_10264() + 10))
            return false;

        if (Oritech.CONFIG.easyFindFeatures())
            placeSurfaceBoulder(boulderPos, context);
        placeBedrockNode(deepNodePos, context);
        Oritech.LOGGER.debug("placing resource node at " + boulderPos + " with deep " + deepNodePos);
        return true;
        
    }
    
    private class_2680 getRandomBlockFromList(List<class_2960> list, class_5819 random) {
        return class_7923.field_41175.method_10223(getRandomFromList(list, random)).method_9564();
    }
    
    private class_2960 getRandomFromList(List<class_2960> list, class_5819 random) {
        return list.get(random.method_43048(list.size()));
    }
    
    private void placeBedrockNode(class_2338 startPos, class_5821<ResourceNodeFeatureConfig> context) {
        
        var world = context.method_33652();
        var random = context.method_33654();
        var ores = context.method_33656().nodeOres();
        
        var radius = context.method_33656().nodeSize();
        var overlayBlock = class_7923.field_41175.method_10223(context.method_33656().overlayBlock()).method_9564();
        var overlayHeight = context.method_33656().overlayHeight();

        var noise = new class_3756(random);

        // the bottom of the "bowl" should start below the top layer of bedrock
        class_2338 centerPos = startPos.method_10086(radius - 2);

        for (class_2338 pos : class_2338.method_25996(centerPos, radius, radius, radius)) {
            // skip anything outside the radius, or outside the vertical cutoff
            if (Math.sqrt(pos.method_10262(centerPos)) + noise.method_33658(pos.method_10263(), pos.method_10264(), pos.method_10260()) > radius
                || pos.method_10264() >= startPos.method_10264() + overlayHeight + 3 + noise.method_33658(pos.method_10263(), pos.method_10264() + 2, pos.method_10260())) continue;
            // randomly replace some blocks below bedrock level with resource nodes
            if (pos.method_10264() <= startPos.method_10264() + 1 && random.method_43058() <= context.method_33656().nodeOreChance()) {
                world.method_8652(pos, getRandomBlockFromList(ores, random), 0x10);
            // set blocks between bedrock and bedrock + overlayHeight to overlayBlock
            } else if (pos.method_10264() > startPos.method_10264() + 1 && pos.method_10264() <= startPos.method_10264() + overlayHeight + 1) {
                world.method_8652(pos, overlayBlock, 0x10);
            // set anything between overlay and vertical cutoff to air
            } else if (pos.method_10264() > startPos.method_10264() + 1) {
                world.method_8652(pos, class_2246.field_10124.method_9564(), 0x10);
            }
        }
    }
    
    private void placeSurfaceBoulder(class_2338 startPos, class_5821<ResourceNodeFeatureConfig> context) {
        
        var world = context.method_33652();
        var random = context.method_33654();
        var radius = context.method_33656().boulderRadius();
        var movedCenter = startPos.method_30513(class_2351.method_16699(random), random.method_39332(0, radius-1));
        var ores = context.method_33656().boulderOres();
        var noise = new class_3756(random);
        
        for (class_2338 pos : class_2338.method_25996(movedCenter, radius, radius, radius)) {
            if (Math.sqrt(pos.method_10262(movedCenter)) > radius + noise.method_33658(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
            world.method_8652(pos, getRandomBlockFromList(ores, random), 0x10);
        }
    }
}
