/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.GenericPipeDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.item.tools.Wrench;

public abstract class GenericPipeBlock
extends AbstractPipeBlock
implements Wrench.Wrenchable {
    public static int NO_CONNECTION = 0;
    public static int CONNECTION = 1;
    public static final class_2758 NORTH = class_2758.method_11867((String)"north", (int)0, (int)1);
    public static final class_2758 EAST = class_2758.method_11867((String)"east", (int)0, (int)1);
    public static final class_2758 SOUTH = class_2758.method_11867((String)"south", (int)0, (int)1);
    public static final class_2758 WEST = class_2758.method_11867((String)"west", (int)0, (int)1);
    public static final class_2758 UP = class_2758.method_11867((String)"up", (int)0, (int)1);
    public static final class_2758 DOWN = class_2758.method_11867((String)"down", (int)0, (int)1);
    public static final class_2746 STRAIGHT = class_2746.method_11825((String)"straight");
    public static final class_265[] THICK_SHAPES = GenericPipeBlock.createShapes(class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), class_2248.method_9541((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), class_2248.method_9541((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0), class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), class_2248.method_9541((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
    public static final class_265[] EXTRA_THICK_SHAPES = GenericPipeBlock.createShapes(class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0), class_2248.method_9541((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), class_2248.method_9541((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), class_2248.method_9541((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0));
    public static final class_265[] THIN_SHAPES = GenericPipeBlock.createShapes(class_2248.method_9541((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), class_2248.method_9541((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), class_2248.method_9541((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), class_2248.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), class_2248.method_9541((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));

    public GenericPipeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)this.getNorthProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)this.getEastProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)this.getSouthProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)this.getWestProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)this.getUpProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)this.getDownProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)STRAIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{this.getNorthProperty(), this.getEastProperty(), this.getSouthProperty(), this.getWestProperty(), this.getUpProperty(), this.getDownProperty(), STRAIGHT});
    }

    @Override
    protected class_265 getShape(class_2680 state) {
        return this.boundingShapes[this.packStates(state)];
    }

    @Override
    protected class_265[] createShapes() {
        return THICK_SHAPES;
    }

    public static class_265[] createShapes(class_265 inner, class_265 north, class_265 east, class_265 south, class_265 west, class_265 up, class_265 down) {
        class_265[] shapes = new class_265[64];
        for (int i = 0; i <= 63; ++i) {
            class_265 shape = inner;
            if ((i & 1) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)north, (class_247)class_247.field_1366);
            }
            if ((i & 2) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)east, (class_247)class_247.field_1366);
            }
            if ((i & 4) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)south, (class_247)class_247.field_1366);
            }
            if ((i & 8) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)west, (class_247)class_247.field_1366);
            }
            if ((i & 0x10) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)up, (class_247)class_247.field_1366);
            }
            if ((i & 0x20) != 0) {
                shape = class_259.method_1082((class_265)shape, (class_265)down, (class_247)class_247.field_1366);
            }
            shapes[i] = shape.method_1097();
        }
        return shapes;
    }

    private int packStates(class_2680 state) {
        int i = 0;
        if ((Integer)state.method_11654((class_2769)this.getNorthProperty()) != NO_CONNECTION) {
            i |= 1;
        }
        if ((Integer)state.method_11654((class_2769)this.getEastProperty()) != NO_CONNECTION) {
            i |= 2;
        }
        if ((Integer)state.method_11654((class_2769)this.getSouthProperty()) != NO_CONNECTION) {
            i |= 4;
        }
        if ((Integer)state.method_11654((class_2769)this.getWestProperty()) != NO_CONNECTION) {
            i |= 8;
        }
        if ((Integer)state.method_11654((class_2769)this.getUpProperty()) != NO_CONNECTION) {
            i |= 0x10;
        }
        if ((Integer)state.method_11654((class_2769)this.getDownProperty()) != NO_CONNECTION) {
            i |= 0x20;
        }
        return i;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_26204().equals(state.method_26204())) {
            return;
        }
        if (oldState.method_27852(this.getConnectionBlock().method_26204())) {
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, this.getNetworkData(world));
            return;
        }
        if (this.hasNeighboringMachine(state, world, pos, true)) {
            class_2680 connectionBlock = this.getConnectionBlock();
            class_2680 interfaceState = ((GenericPipeBlock)connectionBlock.method_26204()).addConnectionStates(connectionBlock, world, pos, true);
            world.method_8501(pos, interfaceState);
        } else {
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, this.getNetworkData(world));
        }
        this.updateNeighbors(world, pos, false);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 worldAccess, class_2338 pos, class_2338 neighborPos) {
        class_1937 world = (class_1937)worldAccess;
        if (world.field_9236) {
            return state;
        }
        if (this.hasMachineInDirection(direction, world, pos, this.apiValidationFunction())) {
            boolean hasMachine = ((Set)this.getNetworkData((class_1937)world).machinePipeNeighbors.getOrDefault(neighborPos, HashSet.newHashSet(0))).contains(direction.method_10153());
            if (hasMachine) {
                return state;
            }
            class_2680 connectionBlock = this.getConnectionBlock();
            return ((GenericPipeBlock)connectionBlock.method_26204()).addConnectionStates(connectionBlock, world, pos, direction);
        }
        if (neighborState.method_27852(class_2246.field_10124)) {
            this.getNetworkData((class_1937)world).machinePipeNeighbors.remove(neighborPos);
        }
        return state;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!state.method_27852(newState.method_26204()) && !(newState.method_26204() instanceof GenericPipeBlock)) {
            this.onBlockRemoved(pos, state, world);
        }
    }

    @Override
    public void updateNeighbors(class_1937 world, class_2338 pos, boolean neighborToggled) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            class_2248 class_22482 = neighborState.method_26204();
            if (!(class_22482 instanceof AbstractPipeBlock)) continue;
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)class_22482;
            class_2680 updatedState = pipeBlock.addConnectionStates(neighborState, world, neighborPos, false);
            world.method_8501(neighborPos, updatedState);
            if (neighborState.equals(updatedState) && !(pipeBlock instanceof GenericPipeDuctBlock)) continue;
            boolean interfaceBlock = updatedState.method_27852(this.getConnectionBlock().method_26204());
            if (!neighborToggled) continue;
            GenericPipeInterfaceEntity.addNode(world, neighborPos, interfaceBlock, updatedState, this.getNetworkData(world));
        }
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!player.method_7337() && !world.field_9236) {
            this.onBlockRemoved(pos, state, world);
        }
        return super.method_9576(world, pos, state, player);
    }

    @Override
    public class_1269 onWrenchUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            this.method_9576(world, pos, state, player);
            world.method_8651(pos, true, (class_1297)player);
            return class_1269.field_5812;
        }
        return !this.toggleSideConnection(state, this.getInteractDirection(state, pos, player), world, pos) ? class_1269.field_5814 : class_1269.field_5812;
    }

    @Override
    public class_1269 onWrenchUseNeighbor(class_2680 state, class_2680 neighborState, class_1937 world, class_2338 pos, class_2338 neighborPos, class_2350 neighborFace, class_1657 player, class_1268 hand) {
        return this.toggleSideConnection(state, neighborFace.method_10153(), world, pos) ? class_1269.field_5812 : class_1269.field_5814;
    }

    protected class_2350 getInteractDirection(class_2680 state, class_2338 pos, class_1657 player) {
        List<class_265> shapes = this.getActiveShapes(state);
        class_243 start = player.method_5836(0.0f);
        class_243 end = start.method_1019(player.method_5828(0.0f).method_1021(5.0));
        class_265 targetShape = shapes.getFirst();
        double distance = Double.MAX_VALUE;
        class_243 hitPos = class_243.field_1353;
        for (class_265 shape : shapes) {
            double shapeDistance;
            class_3965 hitResult = shape.method_1092(start, end, pos);
            if (hitResult == null || !((shapeDistance = hitResult.method_17784().method_1022(start)) < distance)) continue;
            distance = shapeDistance;
            targetShape = shape;
            hitPos = hitResult.method_17784();
        }
        class_243 center = targetShape.method_1107().method_1005();
        class_243 diff = center.method_1020(new class_243(0.5, 0.5, 0.5));
        if (diff.equals((Object)class_243.field_1353)) {
            diff = hitPos.method_1020(center.method_1019(class_243.method_24954((class_2382)pos)));
        }
        return class_2350.method_10142((double)diff.field_1352, (double)diff.field_1351, (double)diff.field_1350);
    }

    private List<class_265> getActiveShapes(class_2680 state) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        if ((Integer)state.method_11654((class_2769)this.getNorthProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0));
        }
        if ((Integer)state.method_11654((class_2769)this.getEastProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        }
        if ((Integer)state.method_11654((class_2769)this.getSouthProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0));
        }
        if ((Integer)state.method_11654((class_2769)this.getWestProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0));
        }
        if ((Integer)state.method_11654((class_2769)this.getUpProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        }
        if ((Integer)state.method_11654((class_2769)this.getDownProperty()) != NO_CONNECTION) {
            shapes.add(class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
        }
        if (shapes.isEmpty()) {
            shapes.add(class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
        }
        return shapes;
    }

    protected boolean toggleSideConnection(class_2680 state, class_2350 side, class_1937 world, class_2338 pos) {
        class_2758 property = this.directionToProperty(side);
        boolean createConnection = (Integer)state.method_11654((class_2769)property) == NO_CONNECTION;
        class_2338 targetPos = pos.method_10093(side);
        if (createConnection && !this.isValidConnectionTarget(world.method_8320(targetPos).method_26204(), world, side.method_10153(), targetPos)) {
            return false;
        }
        int nextConnectionState = this.getNextConnectionState(state, side, world, pos, (Integer)state.method_11654((class_2769)property));
        class_2680 newState = this.addStraightState((class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(nextConnectionState)));
        if (!newState.method_27852(this.getConnectionBlock().method_26204()) && createConnection && this.hasMachineInDirection(side, world, pos, this.apiValidationFunction())) {
            class_2680 connectionState = this.getConnectionBlock();
            class_2680 interfaceState = ((GenericPipeBlock)connectionState.method_26204()).addConnectionStates(connectionState, world, pos, side);
            world.method_8501(pos, interfaceState);
        } else {
            world.method_8501(pos, newState);
            GenericPipeInterfaceEntity.addNode(world, pos, false, newState, this.getNetworkData(world));
            this.updateNeighbors(world, pos, true);
        }
        class_2498 soundGroup = this.method_9573(state);
        world.method_8396(null, pos, soundGroup.method_10598(), class_3419.field_15245, soundGroup.method_10597() * 0.5f, soundGroup.method_10599());
        return true;
    }

    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
        for (class_2350 direction : class_2350.values()) {
            class_2758 property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, createConnection);
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addStraightState(state);
    }

    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection) {
        for (class_2350 direction : class_2350.values()) {
            class_2758 property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, direction.equals((Object)createDirection));
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addStraightState(state);
    }

    @Override
    public class_2680 addStraightState(class_2680 state) {
        boolean north = (Integer)state.method_11654((class_2769)this.getNorthProperty()) != NO_CONNECTION;
        boolean south = (Integer)state.method_11654((class_2769)this.getSouthProperty()) != NO_CONNECTION;
        boolean east = (Integer)state.method_11654((class_2769)this.getEastProperty()) != NO_CONNECTION;
        boolean west = (Integer)state.method_11654((class_2769)this.getWestProperty()) != NO_CONNECTION;
        boolean up = (Integer)state.method_11654((class_2769)this.getUpProperty()) != NO_CONNECTION;
        boolean down = (Integer)state.method_11654((class_2769)this.getDownProperty()) != NO_CONNECTION;
        boolean straightX = north && south && !east && !west && !up && !down;
        boolean straightY = up && down && !north && !south && !east && !west;
        boolean straightZ = east && west && !north && !south && !up && !down;
        boolean straight = straightX || straightY || straightZ;
        return (class_2680)state.method_11657((class_2769)STRAIGHT, (Comparable)Boolean.valueOf(straight));
    }

    @Override
    public boolean shouldConnect(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
        class_2338 targetPos = currentPos.method_10093(direction);
        class_2680 targetState = world.method_8320(targetPos);
        if (createConnection) {
            return this.isValidConnectionTarget(targetState.method_26204(), world, direction.method_10153(), targetPos);
        }
        class_2248 class_22482 = targetState.method_26204();
        if (class_22482 instanceof AbstractPipeBlock) {
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)class_22482;
            return pipeBlock.isConnectingInDirection(targetState, direction.method_10153(), targetPos, world, false);
        }
        return this.isConnectingInDirection(current, direction, currentPos, world, false) && this.isValidInterfaceTarget(targetState.method_26204(), world, direction.method_10153(), targetPos);
    }

    @Override
    public boolean isConnectingInDirection(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
        class_2248 block = current.method_26204();
        if (!(block instanceof GenericPipeBlock)) {
            return false;
        }
        GenericPipeBlock pipeBlock = (GenericPipeBlock)block;
        class_2758 property = pipeBlock.directionToProperty(direction);
        return (Integer)current.method_11654((class_2769)property) >= CONNECTION || createConnection && (Integer)current.method_11654((class_2769)property) == NO_CONNECTION;
    }

    public int directionToPropertyValue(class_2680 state, class_2350 direction) {
        if (direction == class_2350.field_11043) {
            return (Integer)state.method_11654((class_2769)this.getNorthProperty());
        }
        if (direction == class_2350.field_11034) {
            return (Integer)state.method_11654((class_2769)this.getEastProperty());
        }
        if (direction == class_2350.field_11035) {
            return (Integer)state.method_11654((class_2769)this.getSouthProperty());
        }
        if (direction == class_2350.field_11039) {
            return (Integer)state.method_11654((class_2769)this.getWestProperty());
        }
        if (direction == class_2350.field_11036) {
            return (Integer)state.method_11654((class_2769)this.getUpProperty());
        }
        return (Integer)state.method_11654((class_2769)this.getDownProperty());
    }

    public class_2758 directionToProperty(class_2350 direction) {
        if (direction == class_2350.field_11043) {
            return this.getNorthProperty();
        }
        if (direction == class_2350.field_11034) {
            return this.getEastProperty();
        }
        if (direction == class_2350.field_11035) {
            return this.getSouthProperty();
        }
        if (direction == class_2350.field_11039) {
            return this.getWestProperty();
        }
        if (direction == class_2350.field_11036) {
            return this.getUpProperty();
        }
        return this.getDownProperty();
    }

    protected int getNextConnectionState(class_2680 state, class_2350 side, class_1937 world, class_2338 pos, int current) {
        return current == NO_CONNECTION ? CONNECTION : NO_CONNECTION;
    }

    @Override
    protected void onBlockRemoved(class_2338 pos, class_2680 oldState, class_1937 world) {
        this.updateNeighbors(world, pos, false);
        GenericPipeInterfaceEntity.removeNode(world, pos, false, oldState, this.getNetworkData(world));
    }

    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    public class_2758 getNorthProperty() {
        return NORTH;
    }

    public class_2758 getEastProperty() {
        return EAST;
    }

    public class_2758 getSouthProperty() {
        return SOUTH;
    }

    public class_2758 getWestProperty() {
        return WEST;
    }

    public class_2758 getUpProperty() {
        return UP;
    }

    public class_2758 getDownProperty() {
        return DOWN;
    }
}

